# CC-ADVANCECYBER

Custom Claude Code distribution with advanced orchestration, 46 specialized agents, 40+ skills, and persistent memory.

## Quick Start

```bash
# Full installation (includes Docker memory backend)
./install.sh --profile full

# Lite installation (agents and skills only)
./install.sh --profile lite
```

## Requirements

- **Claude Code** (installed via Anthropic)
- **Docker Desktop** (for memory backend - full profile only)
- **Ollama** (for local embeddings - recommended for full profile)

## What's Included

### 46 Specialized Agents

| Category | Agents |
|----------|--------|
| Orchestration | conductor, pm, crew, handoff, planner, dynamic-router |
| Development | architect, auto-code, bug-find, refactor, project-setup, frontend-designer, optimize, agent-builder, skill-sdk, command-builder |
| Quality | qa, critic, code-reviewer, ciso, compliance |
| Documentation | doc-gen, api-docs, prd-manager |
| Infrastructure | devops, database, performance, observability, api-design, mcp-manager |
| Analysis | analyze-codebase, research, root-cause |
| Memory | memory-system |
| Utilities | context-translator, context-manager, offline-dev |
| Advanced | self-improve, checkpoint, guardrails, time-travel, tracer, confidence, feedback-loop, improvement-workflow |
| Automation | n8n |

### 40+ Skills

Including document-skills, n8n-comprehensive, webapp-testing, frontend-design, and many more.

### Persistent Memory System

Local memory backend using:
- **Qdrant** - Vector database for semantic search
- **PostgreSQL** - Structured data storage
- **n8n** - Workflow automation
- **Ollama** - Local embeddings

All data stays local - nothing sent to external servers.

## Installation Profiles

| Profile | Components | Docker Required |
|---------|------------|-----------------|
| `full` | Agents + Skills + Memory + MCP | Yes |
| `lite` | Agents + Skills only | No |

## Post-Installation

1. **Restart Claude Code** to load new agents
2. **Start memory backend** (full profile):
   ```bash
   cd ~/docker/local && docker compose up -d
   ```
3. **Verify installation**:
   ```bash
   ./scripts/verify-install.sh
   ```

## Directory Structure

```
~/.claude/
├── agents/           # 46 agent definitions
├── skills/           # 40+ skill directories
├── CLAUDE.md         # Global instructions
└── settings.local.json  # MCP server configuration

~/docker/local/       # Memory backend (full profile)
├── docker-compose.yml
├── .env
└── setup.sh
```

## Configuration

### API Keys

Set your Anthropic API key:
```bash
export ANTHROPIC_API_KEY=sk-ant-...
```

### Alternative Providers

See `providers/` directory for OpenRouter and local LLM configurations.

## Security

- All Docker services bind to localhost only (127.0.0.1)
- All services require authentication
- Containers run as non-root (UID 1000)
- No external data transmission

## Documentation

- [Installation Guide](docs/installation.md)
- [Agent Reference](docs/agents.md)
- [Skill Reference](docs/skills.md)
- [Memory System](docs/memory.md)

## Support

- **Issues**: https://github.com/advancecyber/cc-advancecyber/issues
- **Documentation**: https://advancecyber.ai/docs

## License

MIT License - See [LICENSE](LICENSE) for details.

---

Built by [AdvanceCyber.ai](https://advancecyber.ai)
