# ADVANCECYBER Configuration

You are running **CC-ADVANCECYBER**, an enterprise Claude Code distribution with enhanced capabilities.

## System Overview

- **46 Specialized Agents** for orchestrated development workflows
- **39+ Skills** for domain-specific tasks
- **Persistent Memory** via Qdrant vector database + n8n workflows
- **Multi-Provider Support**: Anthropic, OpenRouter, CCRouter

## Available Agent Categories

### Orchestration
- `conductor` - Multi-agent workflow orchestration
- `planner` - Interactive planning with approval gates
- `handoff` - Structured agent-to-agent transfers

### Development
- `architect` - Feature specification and design
- `auto-code` - Automated implementation from specs
- `code-reviewer` - Comprehensive code review
- `refactor` - Code restructuring and modernization

### Quality & Security
- `qa` - Test planning and gap analysis
- `ciso` - Security review and threat modeling
- `critic` - Skeptical validation at checkpoints
- `compliance` - Regulatory compliance checking

### DevOps & Infrastructure
- `devops` - CI/CD and deployment automation
- `database` - Schema management and migrations
- `api-design` - OpenAPI specs and contract testing
- `performance` - Load testing and optimization

### Documentation
- `doc-gen` - README, architecture docs, SBOM
- `api-docs` - OpenAPI documentation generation

## Memory System

Your persistent memory is powered by:
- **Qdrant** (port 6334) - Vector similarity search
- **n8n** (port 5679) - Workflow automation
- **PostgreSQL** - Relational data storage
- **Ollama** - Local embedding generation

### Memory Commands
```
mcp__claude-memory__memory_store    # Store new memory
mcp__claude-memory__memory_recall   # Recall relevant memories
mcp__claude-memory__rag_search      # RAG-based search
```

## Provider Configuration

Current provider can be switched via environment variables:

```bash
# Anthropic (default)
export ANTHROPIC_API_KEY=sk-ant-...

# OpenRouter
export CC_PROVIDER=openrouter
export OPENROUTER_API_KEY=sk-or-...

# CCRouter (local LLMs)
export CC_PROVIDER=ccrouter
```

## Quick Commands

- `cc-advancecyber doctor` - Health check
- `cc-advancecyber agents` - List all agents
- `cc-advancecyber skills` - List all skills
- `cc-advancecyber memory start` - Start memory backend

## Documentation

https://advancecyber.ai/docs
