# CCRouter Provider (Local LLMs)

Route Claude Code through local LLM infrastructure for offline usage, privacy, or cost reduction.

## Supported Backends

### Ollama (Recommended)

```bash
export CC_PROVIDER=ccrouter
export OLLAMA_MODEL=qwen2.5-coder:32b
```

**Recommended Models for Coding**:
| Model | Size | Use Case |
|-------|------|----------|
| qwen2.5-coder:32b | 32B | Best local coding model |
| codestral:22b | 22B | Mistral's code model |
| deepseek-coder-v2 | 16B | Good for code generation |

**Install Ollama**:
```bash
# macOS
brew install ollama

# Start Ollama
ollama serve

# Pull model
ollama pull qwen2.5-coder:32b
```

### DeepSeek API

```bash
export CC_PROVIDER=ccrouter
export DEEPSEEK_API_KEY=sk-...
```

**Models**:
- deepseek-chat
- deepseek-coder

## Limitations

- Local models have less capability than Claude
- May not support all Claude Code features
- Embedding generation still requires Ollama

## When to Use

- Offline development (airplane, air-gapped)
- Privacy-sensitive work
- High-volume, cost-sensitive tasks
- Model experimentation
