# OpenRouter Provider

Multi-model gateway supporting various AI providers through a single API.

## Configuration

```bash
export CC_PROVIDER=openrouter
export OPENROUTER_API_KEY=sk-or-...
export ANTHROPIC_DEFAULT_SONNET_MODEL=anthropic/claude-sonnet-4
```

## Models Available

| Provider | Model | ID |
|----------|-------|-----|
| Anthropic | Claude Opus 4.5 | anthropic/claude-opus-4-5 |
| Anthropic | Claude Sonnet 4 | anthropic/claude-sonnet-4 |
| Anthropic | Claude Haiku 3.5 | anthropic/claude-3.5-haiku |
| Google | Gemini 2.0 Pro | google/gemini-2.0-flash-001 |
| OpenAI | GPT-4 Turbo | openai/gpt-4-turbo |
| Meta | Llama 3.1 405B | meta-llama/llama-3.1-405b-instruct |

## Pricing

OpenRouter charges per token with provider-specific rates.
See: https://openrouter.ai/pricing

## Use Cases

- Model comparison/testing
- Cost optimization (use cheaper models for simple tasks)
- Access to models not available directly
