# Hostinger API Quick Reference

## Authentication
```
Authorization: Bearer YOUR_API_TOKEN
Content-Type: application/json
Base URL: https://developers.hostinger.com
```

## Most Used Endpoints

### Domains
| Action | Method | Endpoint |
|--------|--------|----------|
| Check availability | GET | `/api/domains/v1/availability?domain={domain}` |
| List domains | GET | `/api/domains/v1/portfolio` |
| Get domain | GET | `/api/domains/v1/portfolio/{domain}` |
| Purchase domain | POST | `/api/domains/v1/portfolio` |
| Update nameservers | PUT | `/api/domains/v1/portfolio/{domain}/nameservers` |
| Toggle lock | PUT | `/api/domains/v1/portfolio/{domain}/lock` |
| Toggle privacy | PUT | `/api/domains/v1/portfolio/{domain}/privacy` |

### DNS
| Action | Method | Endpoint |
|--------|--------|----------|
| Get records | GET | `/api/dns/v1/zones/{domain}` |
| Update records | PUT | `/api/dns/v1/zones/{domain}` |
| Delete record | DELETE | `/api/dns/v1/zones/{domain}/{record_id}` |
| Create snapshot | POST | `/api/dns/v1/snapshots/{domain}` |
| Restore snapshot | POST | `/api/dns/v1/snapshots/{domain}/{snapshot_id}/restore` |

### VPS
| Action | Method | Endpoint |
|--------|--------|----------|
| List VPS | GET | `/api/vps/v1/virtual-machines` |
| Get VPS | GET | `/api/vps/v1/virtual-machines/{id}` |
| Start | POST | `/api/vps/v1/virtual-machines/{id}/start` |
| Stop | POST | `/api/vps/v1/virtual-machines/{id}/stop` |
| Restart | POST | `/api/vps/v1/virtual-machines/{id}/restart` |
| Recreate | POST | `/api/vps/v1/virtual-machines/{id}/recreate` |
| Recovery mode | POST | `/api/vps/v1/virtual-machines/{id}/recovery` |
| Get metrics | GET | `/api/vps/v1/metrics/{vm_id}?from=&to=&metric=` |

### VPS Firewall
| Action | Method | Endpoint |
|--------|--------|----------|
| List rules | GET | `/api/vps/v1/firewall/{vm_id}/rules` |
| Add rule | POST | `/api/vps/v1/firewall/{vm_id}/rules` |
| Delete rule | DELETE | `/api/vps/v1/firewall/{vm_id}/rules/{rule_id}` |
| Activate | POST | `/api/vps/v1/firewall/{vm_id}/activate` |
| Deactivate | POST | `/api/vps/v1/firewall/{vm_id}/deactivate` |
| Sync | POST | `/api/vps/v1/firewall/{vm_id}/sync` |

### VPS Docker
| Action | Method | Endpoint |
|--------|--------|----------|
| List projects | GET | `/api/vps/v1/docker/{vm_id}/projects` |
| Deploy project | POST | `/api/vps/v1/docker/{vm_id}/projects` |
| Delete project | DELETE | `/api/vps/v1/docker/{vm_id}/projects/{name}` |
| List containers | GET | `/api/vps/v1/docker/{vm_id}/containers` |
| Start container | POST | `/api/vps/v1/docker/{vm_id}/containers/{id}/start` |
| Stop container | POST | `/api/vps/v1/docker/{vm_id}/containers/{id}/stop` |
| Get logs | GET | `/api/vps/v1/docker/{vm_id}/containers/{id}/logs` |

### SSH Keys
| Action | Method | Endpoint |
|--------|--------|----------|
| List keys | GET | `/api/vps/v1/public-keys` |
| Add key | POST | `/api/vps/v1/public-keys` |
| Delete key | DELETE | `/api/vps/v1/public-keys/{id}` |
| Attach to VM | POST | `/api/vps/v1/virtual-machines/{id}/public-keys` |

### Billing
| Action | Method | Endpoint |
|--------|--------|----------|
| List subscriptions | GET | `/api/billing/v1/subscriptions` |
| Get subscription | GET | `/api/billing/v1/subscriptions/{id}` |
| Toggle auto-renewal | PUT | `/api/billing/v1/subscriptions/{id}/auto-renewal` |
| Cancel | POST | `/api/billing/v1/subscriptions/{id}/cancel` |
| Browse catalog | GET | `/api/billing/v1/catalog` |

### Email Marketing (Reach)
| Action | Method | Endpoint |
|--------|--------|----------|
| List contacts | GET | `/api/reach/v1/contacts` |
| Create contact | POST | `/api/reach/v1/contacts` |
| Delete contact | DELETE | `/api/reach/v1/contacts/{id}` |
| List segments | GET | `/api/reach/v1/segments` |
| Create segment | POST | `/api/reach/v1/segments` |

## Common Request Bodies

### DNS Record
```json
{
  "records": [
    {"type": "A", "name": "@", "content": "1.2.3.4", "ttl": 3600},
    {"type": "CNAME", "name": "www", "content": "example.com", "ttl": 3600},
    {"type": "MX", "name": "@", "content": "mail.example.com", "ttl": 3600, "priority": 10}
  ]
}
```

### Firewall Rule
```json
{
  "protocol": "TCP",
  "port": "443",
  "source": "0.0.0.0/0",
  "action": "accept"
}
```

### Docker Project
```json
{
  "name": "my-project",
  "compose": "version: '3'\nservices:\n  web:\n    image: nginx:latest\n    ports:\n      - '80:80'"
}
```

### Email Contact
```json
{
  "email": "user@example.com",
  "first_name": "John",
  "last_name": "Doe",
  "subscribed": true
}
```

## Rate Limits
| Endpoint | Limit |
|----------|-------|
| Domain availability | 10/minute |
| General | Varies by endpoint |

## Error Response Format
```json
{
  "error": "Description",
  "correlation_id": "uuid"
}
```

## Validation Error (422)
```json
{
  "message": "Validation failed",
  "errors": {
    "field": ["error message"]
  },
  "correlation_id": "uuid"
}
```
