# Marketplace Skill

Search, browse, and install skills from the AdvanceCyber.ai Skills Marketplace.

## Invocation
- `/marketplace` - Open marketplace browser
- `/marketplace search <query>` - Search for skills
- `/marketplace install <skill-id>` - Install a skill
- `/marketplace list` - List all available skills
- `/marketplace categories` - Show skill categories

## API Endpoint
```
https://advancecyber.ai/api/skills.json
```

## Commands

### List All Skills
```bash
curl -s https://advancecyber.ai/api/skills.json | jq -r '.skills[] | "\(.id): \(.name) - \(.description)"'
```

### Search Skills
```bash
# By name/description
curl -s https://advancecyber.ai/api/skills.json | jq -r '.skills[] | select(.name | test("QUERY"; "i")) | "\(.id): \(.name)"'

# By category
curl -s https://advancecyber.ai/api/skills.json | jq -r '.skills[] | select(.category == "CATEGORY") | "\(.id): \(.name)"'

# By tag
curl -s https://advancecyber.ai/api/skills.json | jq -r '.skills[] | select(.tags | contains(["TAG"])) | "\(.id): \(.name)"'
```

### Install a Skill
```bash
SKILL_ID="skill-name"
curl -sL "https://advancecyber.ai/downloads/skills/${SKILL_ID}.zip" -o /tmp/${SKILL_ID}.zip
unzip -oq /tmp/${SKILL_ID}.zip -d ~/.claude/skills/
rm /tmp/${SKILL_ID}.zip
echo "Installed ${SKILL_ID} to ~/.claude/skills/"
```

### Get Skill Details
```bash
curl -s https://advancecyber.ai/api/skills.json | jq '.skills[] | select(.id == "SKILL_ID")'
```

### List Categories
```bash
curl -s https://advancecyber.ai/api/skills.json | jq -r '.categories[] | "\(.id): \(.name) (\(.count) skills)"'
```

## Workflow

When user invokes `/marketplace`:

1. **No arguments**: Show overview with categories and total skill count
2. **`search <query>`**: Search skills by name, description, or tags
3. **`install <skill-id>`**: Download and install the skill
4. **`list`**: Show all available skills grouped by category
5. **`categories`**: Show available categories with counts

## Installation Target
Skills are installed to: `~/.claude/skills/`

## Example Session

```
User: /marketplace search design