# Claude Memory System - Local Setup Package

A persistent memory system for Claude Code using local infrastructure. All data stays on your machine - no external cloud services required.

## Architecture Overview

```
┌─────────────────────────────────────────────────────────────────┐
│                     QDRANT VECTOR DATABASE                       │
│                    (Primary Data Store)                          │
├─────────────────────────────────┬───────────────────────────────┤
│      claude_memories            │        obsidian_docs          │
│      (Primary Memory)           │    (Additional Vault Access)  │
│         ▲                       │            ▲                  │
│         │ store/recall          │            │ rag_search       │
└─────────┼───────────────────────┼────────────┼──────────────────┘
          │                       │            │
          └───────────┬───────────┴────────────┘
                      │
              ┌───────▼───────┐     ┌────────────────┐
              │  n8n Workflow │────▶│  Host Ollama   │
              │  (port 5679)  │     │  (port 11434)  │
              └───────┬───────┘     └────────────────┘
                      │
              ┌───────▼───────┐
              │   MCP Server  │
              │ (Claude Code) │
              └───────────────┘
```

## Components

| Service    | Port  | Description                           |
|------------|-------|---------------------------------------|
| n8n        | 5679  | Workflow automation (webhook API)     |
| qdrant     | 6334  | Primary vector database for storage   |
| postgres   | 5432  | n8n persistence database              |

## Prerequisites

1. **Docker & Docker Compose** - For running services
2. **Ollama** - For local embeddings (install from https://ollama.ai)
3. **Node.js 18+** - For MCP server

## Installation

### 1. Extract and Configure

```bash
# Extract package
unzip claude-memory-system.zip -d ~/claude-memory

# Navigate to directory
cd ~/claude-memory

# Create environment file from template
cp .env.template .env

# Edit .env with your preferred values (generate random keys)
vi .env
```

### 2. Start Services

```bash
# Start Docker containers
docker-compose up -d

# Verify services are running
docker-compose ps
```

### 3. Pull Ollama Model

```bash
# Pull the embedding model
ollama pull nomic-embed-text
```

### 4. Build MCP Server

```bash
cd claude-memory-mcp
npm install
npm run build
```

### 5. Configure Claude Code

Add to your `~/.mcp.json`:

```json
{
  "mcpServers": {
    "claude-memory": {
      "command": "node",
      "args": ["/path/to/claude-memory/claude-memory-mcp/dist/index.js"],
      "env": {
        "MEMORY_WEBHOOK_URL": "http://localhost:5679/webhook/memory",
        "MEMORY_WEBHOOK_API_KEY": "your-webhook-api-key-from-env"
      }
    }
  }
}
```

### 6. Import n8n Workflow

1. Open n8n at http://localhost:5679
2. Create initial admin account
3. Import workflow from `n8n/backup/workflows/claude-memory-workflow.json`
4. Activate the workflow

### 7. Restart Claude Code

Restart Claude Code CLI to load the MCP server.

## Available Tools

| Tool | Description |
|------|-------------|
| `memory_store` | Store information with semantic embeddings |
| `memory_recall` | Search memories using natural language |
| `rag_search` | Search Obsidian vault (optional) |
| `memory_scratch` | Working memory for complex reasoning |
| `memory_promote` | Promote memory between tiers |
| `memory_summarize` | Consolidate multiple memories |
| `episode` | Record task episodes for learning |
| `learning` | Store/search learnings from tasks |
| `benchmark` | Track agent performance metrics |

## Usage Examples

Claude Code will automatically use these tools. You can also configure your CLAUDE.md to prompt automatic recall:

```markdown
## Persistent Memory System

At the START of every conversation, use `memory_recall` to search for relevant context.
Proactively use `memory_store` to remember preferences, decisions, and facts.
```

## Security

- All data stored locally (never leaves your machine)
- Embeddings generated locally via Ollama
- API keys protect service endpoints
- No external cloud dependencies

## Troubleshooting

### Services not starting
```bash
docker-compose logs -f
```

### Memory operations failing
- Verify Ollama is running: `curl http://localhost:11434/api/tags`
- Check n8n workflow is active
- Verify webhook API key matches configuration

### MCP server not loading
- Rebuild: `cd claude-memory-mcp && npm run build`
- Check ~/.mcp.json syntax
- Restart Claude Code

## More Information

Visit: https://advancecyber.ai/memory.html

Generated: 2026-01-11
