---
name: reindex
description: Re-index the Obsidian vault for RAG search. Scans markdown, PDF, and MS Office files, generates embeddings via Ollama, and stores in Qdrant. Use when you've added new files to Obsidian or want to refresh the search index.
---

# Obsidian Vault Reindexer

Re-indexes the Obsidian vault to update the RAG search system with new or modified content.

## What It Does

1. Scans the Obsidian vault for supported files:
   - Markdown (.md)
   - PDF (.pdf)
   - Word documents (.docx)
   - Excel spreadsheets (.xlsx)
   - PowerPoint presentations (.pptx)

2. Generates embeddings using local Ollama (nomic-embed-text model)

3. Stores document chunks in Qdrant vector database (obsidian_docs collection)

4. Uses content hashing for incremental updates - only re-indexes changed files

## Prerequisites

- Docker containers must be running: `docker-compose up -d` in `/Users/marcvance/Documents/Code/claude_backend/`
- Ollama must be running locally with `nomic-embed-text` model

## Execution

Run the indexer using the virtual environment:

```bash
/Users/marcvance/Documents/Code/claude_backend/scripts/venv/bin/python3 /Users/marcvance/Documents/Code/claude_backend/scripts/index-obsidian.py
```

## Configuration

| Setting | Value |
|---------|-------|
| Vault Path | `/Users/marcvance/Library/Mobile Documents/iCloud~md~obsidian/Documents/Obsidian` |
| Qdrant URL | `http://localhost:6334` |
| Collection | `obsidian_docs` |
| Chunk Size | 1000 characters |
| Chunk Overlap | 200 characters |

## Skipped Directories

- .obsidian
- .git
- .trash
- node_modules
- .claude

## Output

The indexer reports:
- Number of files found by type
- Files indexed (new/changed)
- Files skipped (unchanged)
- Total chunks created
- Any errors encountered

## When to Use

- After adding new documents to Obsidian
- After modifying existing documents
- When RAG search isn't finding expected content
- Periodically to ensure index is up to date
