---
name: slides
description: Generate professional presentation slides from documents using Google Gemini directly. This skill should be used when the user asks to "create slides", "generate a presentation", "make a deck", "turn this into slides", or provides a document (PDF, PPTX, DOCX, TXT, MD) to convert into slides. The skill reads the file, interactively asks for vibe and settings using AskUserQuestion, then runs the standalone generator script. Output is a single PDF file on ~/Desktop by default.
---

# Slides Generator

Generate AI-powered presentation slides from documents using Google Gemini's image generation directly. No external dependencies - completely standalone.

**Requirements:**
- `GEMINI_API_KEY` set in environment or `~/Documents/Code/PPT2Vid/.env`

## Workflow

### Step 1: Read the File

Read the provided file (PDF, PPTX, DOCX, TXT, or MD) to understand its content. Summarize the document.

### Step 2: Ask for Vibe

Use AskUserQuestion to ask which vibe. Present 4 options (AskUserQuestion limit):

```json
{
  "questions": [{
    "question": "Which visual style (vibe) would you like for your slides?",
    "header": "Vibe",
    "options": [
      {"label": "Corporate (Recommended)", "description": "Clean, professional, minimalist geometry"},
      {"label": "Tech", "description": "Isometric graphics, neon accents"},
      {"label": "Executive", "description": "C-suite, dark premium boardroom style"},
      {"label": "More options...", "description": "See all 41 available vibes"}
    ],
    "multiSelect": false
  }]
}
```

**If "More options", show categories:**
```json
{
  "questions": [{
    "question": "Which vibe category?",
    "header": "Category",
    "options": [
      {"label": "Design Classics", "description": "swiss, bauhaus, art-deco, japanese-minimal, midcentury"},
      {"label": "Tech/Digital", "description": "cyberpunk, saas, terminal, blockchain, ai-neural, dark-mode, glassmorphism"},
      {"label": "Professional", "description": "consulting, financial, legal, military"},
      {"label": "Creative/Specialty", "description": "anime, graffiti, space, luxury, newspaper, sports, watercolor, scrapbook"}
    ],
    "multiSelect": false
  }]
}
```

**All 41 vibes:**
| Category | Vibes |
|----------|-------|
| Original | corporate, sketchnotes, tech, minimal, bold, keynote, pitch-deck, playful, vintage, hand-drawn, editorial, training |
| Design Classics | swiss, japanese-minimal, bauhaus, midcentury, art-deco |
| Professional | executive, consulting, financial, legal, military |
| Tech/Digital | dark-mode, cyberpunk, saas, terminal, blockchain, ai-neural, glassmorphism |
| Nature | watercolor, earth-tones, ocean, forest |
| Specialty | vintage-scientific, newspaper, graffiti, sports, festival, space, industrial, luxury |
| New Styles | photorealistic, scrapbook, dashboard, minecraft, collage, high-end-editorial, anime, flowchart, workflow |

### Step 3: Ask for Settings

**Question 1 - Core settings:**
```json
{
  "questions": [
    {
      "question": "How many slides?",
      "header": "Slides",
      "options": [
        {"label": "5 slides", "description": "Brief overview"},
        {"label": "10 slides", "description": "Standard presentation"},
        {"label": "15 slides", "description": "Comprehensive coverage"},
        {"label": "Custom", "description": "Specify 1-15"}
      ],
      "multiSelect": false
    },
    {
      "question": "Information density?",
      "header": "Density",
      "options": [
        {"label": "Concise", "description": "Minimal text, key points only"},
        {"label": "Standard (Recommended)", "description": "Balanced content"},
        {"label": "Dense", "description": "Comprehensive detail"}
      ],
      "multiSelect": false
    }
  ]
}
```

**Question 2 - Intent:**
```json
{
  "questions": [{
    "question": "Presentation intent?",
    "header": "Intent",
    "options": [
      {"label": "Inform", "description": "Deliver facts, data, knowledge"},
      {"label": "Persuade", "description": "Convince audience"},
      {"label": "Train", "description": "Teach skills or procedures"},
      {"label": "More...", "description": "See all 29 intents"}
    ],
    "multiSelect": false
  }]
}
```

**All 29 intents:** inform, building-process, brainstorming, comparison, emotion, persuade, inspire, report, propose, request, warn, celebrate, introduce, train, pitch, justify, align, onboard, summarize, recommend, challenge, establish-credibility, create-urgency, simplify, document, provoke, reassure, secure-commitment

**Question 3 - Optional customization:**
```json
{
  "questions": [{
    "question": "Additional customization?",
    "header": "Options",
    "options": [
      {"label": "Use defaults", "description": "Generate now"},
      {"label": "Set audience", "description": "Specify target audience"},
      {"label": "Color palette", "description": "Override vibe colors"},
      {"label": "Special slides", "description": "Title, Summary, Thank You"}
    ],
    "multiSelect": true
  }]
}
```

**Color palettes (25):** midnight-executive, nordic-frost, cyber-neon, desert-sand, ocean-depth, forest-canopy, sunset-gradient, monochrome-gray, corporate-trust, berry-luxe, mint-fresh, warm-terracotta, electric-violet, newspaper-classic, synthwave-sunset, sage-stone, tech-slate, coral-reef, arctic-blue, gold-standard, pastel-dream, industrial-steel, nature-botanical, cybersecurity-dark, warm-minimal

### Step 4: Generate Slides

Run the standalone generator script:

```bash
python3 ~/.claude/skills/slides/scripts/generate_slides.py \
  "<file_path>" \
  --vibe <vibe> \
  --slides <num> \
  --density <density> \
  --intent <intent> \
  [--palette <palette>] \
  [--audience "<audience>"] \
  [--title-slide] \
  [--thank-you-slide] \
  [--output <directory>]
```

**Default output:** `~/Desktop/slides_<timestamp>.pdf`

**Example:**
```bash
python3 ~/.claude/skills/slides/scripts/generate_slides.py \
  "/path/to/document.pdf" \
  --vibe executive \
  --slides 10 \
  --density dense \
  --intent align \
  --audience "C-Suite Executives" \
  --title-slide
```

### Step 5: Report Results

After generation completes, report:
- Number of slides generated
- Generation time
- PDF file path

## Script Reference

The `scripts/generate_slides.py` script is completely standalone (no PPT2Vid dependencies):

```
--vibe, -v        Visual style (41 options)
--slides, -n      Number of slides 1-15 (default: 10)
--density, -d     concise|standard|dense (default: standard)
--intent, -i      Presentation intent (29 options, default: inform)
--palette, -p     Color palette override (25 options)
--audience, -a    Target audience description
--output, -o      Output path/directory (default: ~/Desktop/slides_<timestamp>.pdf)

Special slides:
--title-slide     Include title slide
--thank-you-slide Include thank you/contact slide

Utilities:
--list-vibes      Show all vibes
--list-intents    Show all intents
--list-palettes   Show all color palettes
```
