---
name: docker-health
description: Check Docker container health status across remote servers (hg, hi, h2). Use when user asks to check Docker health, container status, or server health.
---

# Docker Health Check Skill

Check the health and status of Docker containers across the user's remote servers.

## Servers

- **hg**: root@50.6.224.116
- **hi**: root@217.15.170.102 (Dockhand at port 5001)
- **h2**: root@168.231.73.5 (Dockhand at port 5001, CoverKit, Nailgun)

## Instructions

1. Connect to each server via SSH using the aliases (hg, hi, h2)
2. Run `docker ps -a --format "table {{.Names}}\t{{.Status}}\t{{.State}}"` to get container status
3. Present a summary showing:
   - Total containers per server
   - Running vs stopped containers
   - Any unhealthy or exited containers (highlight these)
4. If any containers are unhealthy or stopped unexpectedly, offer to show logs

## Commands to Run

```bash
# For each server (hg, hi, h2):
ssh <alias> 'docker ps -a --format "table {{.Names}}\t{{.Status}}\t{{.State}}"'
```

## Output Format

Present results in a clear table format per server:

```
## Server: <name> (<ip>)
| Container | Status | State |
|-----------|--------|-------|
| ...       | ...    | ...   |

Summary: X running, Y stopped, Z unhealthy
```

## Error Handling

- If SSH connection fails, report the error and continue to next server
- If Docker is not running, report that and continue
- Note any permission issues
