# API Catalog Index

This comprehensive catalog includes 1,425+ free public APIs from the [public-apis](https://github.com/public-apis/public-apis) repository, automatically imported and organized by category.

## How to Use This Catalog

When you need an API for a specific task, the api-catalog skill will automatically search this file to find relevant APIs. You can also browse this file directly to discover new APIs.

## Adding Your Custom APIs

To add your own APIs to this catalog, simply add new sections following the same format:

```markdown
### Your API Name
- **Description**: What the API does
- **Documentation**: https://your-api-docs.com
- **OpenAPI Spec**: https://your-api-docs.com/openapi.yaml (if available)
- **Category**: Your Category
- **Auth Type**: API Key / OAuth2 / None / etc.
- **HTTPS**: Yes / No
- **CORS**: Yes / No / Unknown
```

---

## OpenAPI-Enabled APIs (Machine-Readable Specs)

These APIs provide OpenAPI/Swagger specifications for automated parsing, typed code generation, and interactive documentation.

### CoverKit Insurance API
- **Description**: Embedded insurance platform for integrating insurance products (shipping protection, extended warranties, travel, pet, rental) into any application
- **Documentation**: https://docs.coverkit.io/
- **OpenAPI Spec**: https://docs.coverkit.io/openapi.yaml
- **Category**: Insurance / Fintech
- **Auth Type**: API Key (X-API-Key header)
- **HTTPS**: Yes
- **CORS**: Yes
- **Rate Limits**: Starter 100/min, Growth 500/min, Enterprise 2000/min
- **Key Endpoints**:
  - `POST /quotes` - Create insurance quote
  - `POST /quotes/{id}/convert` - Convert quote to policy
  - `GET /policies` - List policies
  - `POST /claims` - Submit claim
  - `GET /products` - Browse insurance products

---

## Quick Stats

- **Total APIs**: 1,425+
- **Categories**: 51
- **Top Categories**:
  - Development: 120 APIs
  - Games & Comics: 96 APIs
  - Geocoding: 86 APIs
  - Government: 86 APIs
  - Transportation: 69 APIs

---

## Categories

- [Animals](#animals)
- [Anime](#anime)
- [Anti-Malware](#anti-malware)
- [Art & Design](#art-design)
- [Authentication & Authorization](#authentication-authorization)
- [Blockchain](#blockchain)
- [Books](#books)
- [Business](#business)
- [Calendar](#calendar)
- [Cloud Storage & File Sharing](#cloud-storage-file-sharing)
- [Continuous Integration](#continuous-integration)
- [Cryptocurrency](#cryptocurrency)
- [Currency Exchange](#currency-exchange)
- [Data Validation](#data-validation)
- [Development](#development)
- [Dictionaries](#dictionaries)
- [Documents & Productivity](#documents-productivity)
- [Email](#email)
- [Entertainment](#entertainment)
- [Environment](#environment)
- [Events](#events)
- [Finance](#finance)
- [Food & Drink](#food-drink)
- [Games & Comics](#games-comics)
- [Geocoding](#geocoding)
- [Government](#government)
- [Health](#health)
- [Jobs](#jobs)
- [Machine Learning](#machine-learning)
- [Music](#music)
- [News](#news)
- [Open Data](#open-data)
- [Open Source Projects](#open-source-projects)
- [Patent](#patent)
- [Personality](#personality)
- [Phone](#phone)
- [Photography](#photography)
- [Programming](#programming)
- [Science & Math](#science-math)
- [Security](#security)
- [Shopping](#shopping)
- [Social](#social)
- [Sports & Fitness](#sports-fitness)
- [Test Data](#test-data)
- [Text Analysis](#text-analysis)
- [Tracking](#tracking)
- [Transportation](#transportation)
- [URL Shorteners](#url-shorteners)
- [Vehicle](#vehicle)
- [Video](#video)
- [Weather](#weather)

---
## Animals

### AdoptAPet
- **Description**: Resource to help get pets adopted
- **Documentation**: https://www.adoptapet.com/public/apis/pet_list.html
- **Category**: Animals
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Axolotl
- **Description**: Collection of axolotl pictures and facts
- **Documentation**: https://theaxolotlapi.netlify.app/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Cat Facts
- **Description**: Daily cat facts
- **Documentation**: https://alexwohlbruck.github.io/cat-facts/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Cataas
- **Description**: Cat as a service (cats pictures and gifs)
- **Documentation**: https://cataas.com/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Cats
- **Description**: Pictures of cats from Tumblr
- **Documentation**: https://docs.thecatapi.com/
- **Category**: Animals
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Dog Facts
- **Description**: Random dog facts
- **Documentation**: https://dukengn.github.io/Dog-facts-API/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Dog Facts
- **Description**: Random facts of Dogs
- **Documentation**: https://kinduff.github.io/dog-api/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Dogs
- **Description**: Based on the Stanford Dogs Dataset
- **Documentation**: https://dog.ceo/dog-api/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### eBird
- **Description**: Retrieve recent or notable birding observations within a region
- **Documentation**: https://documenter.getpostman.com/view/664302/S1ENwy59
- **Category**: Animals
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### FishWatch
- **Description**: Information and pictures about individual fish species
- **Documentation**: https://www.fishwatch.gov/developers
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### HTTP Cat
- **Description**: Cat for every HTTP Status
- **Documentation**: https://http.cat/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### HTTP Dog
- **Description**: Dogs for every HTTP response status code
- **Documentation**: https://http.dog/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### IUCN
- **Description**: IUCN Red List of Threatened Species
- **Documentation**: http://apiv3.iucnredlist.org/api/v3/docs
- **Category**: Animals
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: No

### MeowFacts
- **Description**: Get random cat facts
- **Documentation**: https://github.com/wh-iterabb-it/meowfacts
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Movebank
- **Description**: Movement and Migration data of animals
- **Documentation**: https://github.com/movebank/movebank-api-doc
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Petfinder
- **Description**: Petfinder is dedicated to helping pets find homes, another resource to get pets adopted
- **Documentation**: https://www.petfinder.com/developers/
- **Category**: Animals
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### PlaceBear
- **Description**: Placeholder bear pictures
- **Documentation**: https://placebear.com/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### PlaceDog
- **Description**: Placeholder Dog pictures
- **Documentation**: https://place.dog
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### PlaceKitten
- **Description**: Placeholder Kitten pictures
- **Documentation**: https://placekitten.com/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### RandomDog
- **Description**: Random pictures of dogs
- **Documentation**: https://random.dog/woof.json
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### RandomDuck
- **Description**: Random pictures of ducks
- **Documentation**: https://random-d.uk/api
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### RandomFox
- **Description**: Random pictures of foxes
- **Documentation**: https://randomfox.ca/floof/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### RescueGroups
- **Description**: Adoption
- **Documentation**: https://userguide.rescuegroups.org/display/APIDG/API+Developers+Guide+Home
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Shibe.Online
- **Description**: Random pictures of Shiba Inu, cats or birds
- **Documentation**: http://shibe.online/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### The Dog
- **Description**: A public service all about Dogs, free to use when making your fancy new App, Website or Service
- **Documentation**: https://thedogapi.com/
- **Category**: Animals
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### xeno-canto
- **Description**: Bird recordings
- **Documentation**: https://xeno-canto.org/explore/api
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Zoo Animals
- **Description**: Facts and pictures of zoo animals
- **Documentation**: https://zoo-animal-api.herokuapp.com/
- **Category**: Animals
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

---

## Anime

### AniAPI
- **Description**: Anime discovery, streaming & syncing with trackers
- **Documentation**: https://aniapi.com/docs/
- **Category**: Anime
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### AniDB
- **Description**: Anime Database
- **Documentation**: https://wiki.anidb.net/HTTP_API_Definition
- **Category**: Anime
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### AniList
- **Description**: Anime discovery & tracking
- **Documentation**: https://github.com/AniList/ApiV2-GraphQL-Docs
- **Category**: Anime
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### AnimeChan
- **Description**: Anime quotes (over 10k+)
- **Documentation**: https://github.com/RocktimSaikia/anime-chan
- **Category**: Anime
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### AnimeFacts
- **Description**: Anime Facts (over 100+)
- **Documentation**: https://chandan-02.github.io/anime-facts-rest-api/
- **Category**: Anime
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### AnimeNewsNetwork
- **Description**: Anime industry news
- **Documentation**: https://www.animenewsnetwork.com/encyclopedia/api.php
- **Category**: Anime
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Catboy
- **Description**: Neko images, funny GIFs & more
- **Documentation**: https://catboys.com/api
- **Category**: Anime
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Danbooru Anime
- **Description**: Thousands of anime artist database to find good anime art
- **Documentation**: https://danbooru.donmai.us/wiki_pages/help:api
- **Category**: Anime
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Jikan
- **Description**: Unofficial MyAnimeList API
- **Documentation**: https://jikan.moe
- **Category**: Anime
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Kitsu
- **Description**: Anime discovery platform
- **Documentation**: https://kitsu.docs.apiary.io/
- **Category**: Anime
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### MangaDex
- **Description**: Manga Database and Community
- **Documentation**: https://api.mangadex.org/docs.html
- **Category**: Anime
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Mangapi
- **Description**: Translate manga pages from one language to another
- **Documentation**: https://rapidapi.com/pierre.carcellermeunier/api/mangapi3/
- **Category**: Anime
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### MyAnimeList
- **Description**: Anime and Manga Database and Community
- **Documentation**: https://myanimelist.net/clubs.php?cid=13727
- **Category**: Anime
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### NekosBest
- **Description**: Neko Images & Anime roleplaying GIFs
- **Documentation**: https://docs.nekos.best
- **Category**: Anime
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Shikimori
- **Description**: Anime discovery, tracking, forum, rates
- **Documentation**: https://shikimori.one/api/doc
- **Category**: Anime
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Studio Ghibli
- **Description**: Resources from Studio Ghibli films
- **Documentation**: https://ghibliapi.herokuapp.com
- **Category**: Anime
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Trace Moe
- **Description**: A useful tool to get the exact scene of an anime from a screenshot
- **Documentation**: https://soruly.github.io/trace.moe-api/#/
- **Category**: Anime
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Waifu.im
- **Description**: Get waifu pictures from an archive of over 4000 images and multiple tags
- **Documentation**: https://waifu.im/docs
- **Category**: Anime
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Waifu.pics
- **Description**: Image sharing platform for anime images
- **Documentation**: https://waifu.pics/docs
- **Category**: Anime
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

---

## Anti-Malware

### AbuseIPDB
- **Description**: IP/domain/URL reputation
- **Documentation**: https://docs.abuseipdb.com/
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### AlienVault Open Threat Exchange (OTX)
- **Description**: IP/domain/URL reputation
- **Documentation**: https://otx.alienvault.com/api
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### CAPEsandbox
- **Description**: Malware execution and analysis
- **Documentation**: https://capev2.readthedocs.io/en/latest/usage/api.html
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Google Safe Browsing
- **Description**: Google Link/Domain Flagging
- **Documentation**: https://developers.google.com/safe-browsing/
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### MalDatabase
- **Description**: Provide malware datasets and threat intelligence feeds
- **Documentation**: https://maldatabase.com/api-doc.html
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### MalShare
- **Description**: Malware Archive / file sourcing
- **Documentation**: https://malshare.com/doc.php
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### MalwareBazaar
- **Description**: Collect and share malware samples
- **Documentation**: https://bazaar.abuse.ch/api/
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Metacert
- **Description**: Metacert Link Flagging
- **Documentation**: https://metacert.com/
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### NoPhishy
- **Description**: Check links to see if they're known phishing attempts
- **Documentation**: https://rapidapi.com/Amiichu/api/exerra-phishing-check/
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Phisherman
- **Description**: IP/domain/URL reputation
- **Documentation**: https://phisherman.gg/
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Scanii
- **Description**: Simple REST API that can scan submitted documents/files for the presence of threats
- **Documentation**: https://docs.scanii.com/
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### URLhaus
- **Description**: Bulk queries and Download Malware Samples
- **Documentation**: https://urlhaus-api.abuse.ch/
- **Category**: Anti-Malware
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### URLScan.io
- **Description**: Scan and Analyse URLs
- **Documentation**: https://urlscan.io/about-api/
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### VirusTotal
- **Description**: VirusTotal File/URL Analysis
- **Documentation**: https://www.virustotal.com/en/documentation/public-api/
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Web of Trust
- **Description**: IP/domain/URL reputation
- **Documentation**: https://support.mywot.com/hc/en-us/sections/360004477734-API-
- **Category**: Anti-Malware
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Art & Design

### Améthyste
- **Description**: Generate images for Discord users
- **Documentation**: https://api.amethyste.moe/
- **Category**: Art & Design
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Art Institute of Chicago
- **Description**: Art
- **Documentation**: https://api.artic.edu/docs/
- **Category**: Art & Design
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Colormind
- **Description**: Color scheme generator
- **Documentation**: http://colormind.io/api-access/
- **Category**: Art & Design
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### ColourLovers
- **Description**: Get various patterns, palettes and images
- **Documentation**: http://www.colourlovers.com/api
- **Category**: Art & Design
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Cooper Hewitt
- **Description**: Smithsonian Design Museum
- **Documentation**: https://collection.cooperhewitt.org/api
- **Category**: Art & Design
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Dribbble
- **Description**: Discover the world’s top designers & creatives
- **Documentation**: https://developer.dribbble.com
- **Category**: Art & Design
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### EmojiHub
- **Description**: Get emojis by categories and groups
- **Documentation**: https://github.com/cheatsnake/emojihub
- **Category**: Art & Design
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Europeana
- **Description**: European Museum and Galleries content
- **Documentation**: https://pro.europeana.eu/resources/apis/search
- **Category**: Art & Design
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Harvard Art Museums
- **Description**: Art
- **Documentation**: https://github.com/harvardartmuseums/api-docs
- **Category**: Art & Design
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Icon Horse
- **Description**: Favicons for any website, with fallbacks
- **Documentation**: https://icon.horse
- **Category**: Art & Design
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Iconfinder
- **Description**: Icons
- **Documentation**: https://developer.iconfinder.com
- **Category**: Art & Design
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Icons8
- **Description**: Icons (find "search icon" hyperlink in page)
- **Documentation**: https://img.icons8.com/
- **Category**: Art & Design
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Lordicon
- **Description**: Icons with predone Animations
- **Documentation**: https://lordicon.com/
- **Category**: Art & Design
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Metropolitan Museum of Art
- **Description**: Met Museum of Art
- **Documentation**: https://metmuseum.github.io/
- **Category**: Art & Design
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Noun Project
- **Description**: Icons
- **Documentation**: http://api.thenounproject.com/index.html
- **Category**: Art & Design
- **Auth Type**: OAuth2
- **HTTPS**: No
- **CORS**: Unknown

### PHP-Noise
- **Description**: Noise Background Image Generator
- **Documentation**: https://php-noise.com/
- **Category**: Art & Design
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Pixel Encounter
- **Description**: SVG Icon Generator
- **Documentation**: https://pixelencounter.com/api
- **Category**: Art & Design
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Rijksmuseum
- **Description**: RijksMuseum Data
- **Documentation**: https://data.rijksmuseum.nl/object-metadata/api/
- **Category**: Art & Design
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Word Cloud
- **Description**: Easily create word clouds
- **Documentation**: https://wordcloudapi.com/
- **Category**: Art & Design
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### xColors
- **Description**: Generate & convert colors
- **Documentation**: https://x-colors.herokuapp.com/
- **Category**: Art & Design
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

---

## Authentication & Authorization

### Auth0
- **Description**: Easy to implement, adaptable authentication and authorization platform
- **Documentation**: https://auth0.com
- **Category**: Authentication & Authorization
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### GetOTP
- **Description**: Implement OTP flow quickly
- **Documentation**: https://otp.dev/en/docs/
- **Category**: Authentication & Authorization
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Micro User Service
- **Description**: User management and authentication
- **Documentation**: https://m3o.com/user
- **Category**: Authentication & Authorization
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### MojoAuth
- **Description**: Secure and modern passwordless authentication platform
- **Documentation**: https://mojoauth.com
- **Category**: Authentication & Authorization
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### SAWO Labs
- **Description**: Simplify login and improve user experience by integrating passwordless authentication in your app
- **Documentation**: https://sawolabs.com
- **Category**: Authentication & Authorization
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Stytch
- **Description**: User infrastructure for modern applications
- **Documentation**: https://stytch.com/
- **Category**: Authentication & Authorization
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Warrant
- **Description**: APIs for authorization and access control
- **Documentation**: https://warrant.dev/
- **Category**: Authentication & Authorization
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

---

## Blockchain

### Bitquery
- **Description**: Onchain GraphQL APIs & DEX APIs
- **Documentation**: https://graphql.bitquery.io/ide
- **Category**: Blockchain
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Chainlink
- **Description**: Build hybrid smart contracts with Chainlink
- **Documentation**: https://chain.link/developer-resources
- **Category**: Blockchain
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Chainpoint
- **Description**: Chainpoint is a global network for anchoring data to the Bitcoin blockchain
- **Documentation**: https://tierion.com/chainpoint/
- **Category**: Blockchain
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Covalent
- **Description**: Multi-blockchain data aggregator platform
- **Documentation**: https://www.covalenthq.com/docs/api/
- **Category**: Blockchain
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Etherscan
- **Description**: Ethereum explorer API
- **Documentation**: https://etherscan.io/apis
- **Category**: Blockchain
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Helium
- **Description**: Helium is a global, distributed network of Hotspots that create public, long-range wireless coverage
- **Documentation**: https://docs.helium.com/api/blockchain/introduction/
- **Category**: Blockchain
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Nownodes
- **Description**: Blockchain-as-a-service solution that provides high-quality connection via API
- **Documentation**: https://nownodes.io/
- **Category**: Blockchain
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Steem
- **Description**: Blockchain-based blogging and social media website
- **Documentation**: https://developers.steem.io/
- **Category**: Blockchain
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: No

### The Graph
- **Description**: Indexing protocol for querying networks like Ethereum with GraphQL
- **Documentation**: https://thegraph.com
- **Category**: Blockchain
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Walltime
- **Description**: To retrieve Walltime's market info
- **Documentation**: https://walltime.info/api.html
- **Category**: Blockchain
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Watchdata
- **Description**: Provide simple and reliable API access to Ethereum blockchain
- **Documentation**: https://docs.watchdata.io
- **Category**: Blockchain
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Books

### A Bíblia Digital
- **Description**: Do not worry about managing the multiple versions of the Bible
- **Documentation**: https://www.abibliadigital.com.br/en
- **Category**: Books
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Bhagavad Gita
- **Description**: Open Source Shrimad Bhagavad Gita API including 21+ authors translation in Sanskrit/English/Hindi
- **Documentation**: https://docs.bhagavadgitaapi.in
- **Category**: Books
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Bhagavad Gita
- **Description**: Bhagavad Gita text
- **Documentation**: https://bhagavadgita.io/api
- **Category**: Books
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Bhagavad Gita telugu
- **Description**: Bhagavad Gita API in telugu and odia languages
- **Documentation**: https://gita-api.vercel.app
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Bible-api
- **Description**: Free Bible API with multiple languages
- **Documentation**: https://bible-api.com/
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### British National Bibliography
- **Description**: Books
- **Documentation**: http://bnb.data.bl.uk/
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Crossref Metadata Search
- **Description**: Books & Articles Metadata
- **Documentation**: https://github.com/CrossRef/rest-api-doc
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Ganjoor
- **Description**: Classic Persian poetry works including access to related manuscripts, recitations and music tracks
- **Documentation**: https://api.ganjoor.net
- **Category**: Books
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Google Books
- **Description**: Books
- **Documentation**: https://developers.google.com/books/
- **Category**: Books
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### GurbaniNow
- **Description**: Fast and Accurate Gurbani RESTful API
- **Documentation**: https://github.com/GurbaniNow/api
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Gutendex
- **Description**: Web-API for fetching data from Project Gutenberg Books Library
- **Documentation**: https://gutendex.com/
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Library
- **Description**: Books, book covers and related data
- **Documentation**: https://openlibrary.org/developers/api
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Penguin Publishing
- **Description**: Books, book covers and related data
- **Documentation**: http://www.penguinrandomhouse.biz/webservices/rest/
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### PoetryDB
- **Description**: Enables you to get instant data from our vast poetry collection
- **Documentation**: https://github.com/thundercomb/poetrydb#readme
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Quran
- **Description**: RESTful Quran API with multiple languages
- **Documentation**: https://quran.api-docs.io/
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Quran Cloud
- **Description**: A RESTful Quran API to retrieve an Ayah, Surah, Juz or the entire Holy Quran
- **Documentation**: https://alquran.cloud/api
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Quran-api
- **Description**: Free Quran API Service with 90+ different languages and 400+ translations
- **Documentation**: https://github.com/fawazahmed0/quran-api#readme
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Rig Veda
- **Description**: Gods and poets, their categories, and the verse meters, with the mandal and sukta number
- **Documentation**: https://aninditabasu.github.io/indica/html/rv.html
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### The Bible
- **Description**: Everything you need from the Bible in one discoverable place
- **Documentation**: https://docs.api.bible
- **Category**: Books
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Thirukkural
- **Description**: 1330 Thirukkural poems and explanation in Tamil and English
- **Documentation**: https://api-thirukkural.web.app/
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Vedic Society
- **Description**: Descriptions of all nouns (names, places, animals, things) from vedic literature
- **Documentation**: https://aninditabasu.github.io/indica/html/vs.html
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Wizard World
- **Description**: Get information from the Harry Potter universe
- **Documentation**: https://wizard-world-api.herokuapp.com/swagger/index.html
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Wolne Lektury
- **Description**: API for obtaining information about e-books available on the WolneLektury.pl website
- **Documentation**: https://wolnelektury.pl/api/
- **Category**: Books
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Business

### Apache Superset
- **Description**: API to manage your BI dashboards and data sources on Superset
- **Documentation**: https://superset.apache.org/docs/api
- **Category**: Business
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Clearbit Logo
- **Description**: Search for company logos and embed them in your projects
- **Documentation**: https://clearbit.com/docs#logo-api
- **Category**: Business
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Domainsdb.info
- **Description**: Registered Domain Names Search
- **Documentation**: https://domainsdb.info/
- **Category**: Business
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Freelancer
- **Description**: Hire freelancers to get work done
- **Documentation**: https://developers.freelancer.com
- **Category**: Business
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Gmail
- **Description**: Flexible, RESTful access to the user's inbox
- **Documentation**: https://developers.google.com/gmail/api/
- **Category**: Business
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Google Analytics
- **Description**: Collect, configure and analyze your data to reach the right audience
- **Documentation**: https://developers.google.com/analytics/
- **Category**: Business
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Instatus
- **Description**: Post to and update maintenance and incidents on your status page through an HTTP REST API
- **Documentation**: https://instatus.com/help/api
- **Category**: Business
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Mailchimp
- **Description**: Send marketing campaigns and transactional mails
- **Documentation**: https://mailchimp.com/developer/
- **Category**: Business
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### mailjet
- **Description**: Marketing email can be sent and mail templates made in MJML or HTML can be sent using API
- **Documentation**: https://www.mailjet.com/
- **Category**: Business
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### markerapi
- **Description**: Trademark Search
- **Documentation**: https://markerapi.com
- **Category**: Business
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### ORB Intelligence
- **Description**: Company lookup
- **Documentation**: https://api.orb-intelligence.com/docs/
- **Category**: Business
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Redash
- **Description**: Access your queries and dashboards on Redash
- **Documentation**: https://redash.io/help/user-guide/integrations-and-api/api
- **Category**: Business
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Smartsheet
- **Description**: Allows you to programmatically access and Smartsheet data and account information
- **Documentation**: https://smartsheet.redoc.ly/
- **Category**: Business
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: No

### Square
- **Description**: Easy way to take payments, manage refunds, and help customers checkout online
- **Documentation**: https://developer.squareup.com/reference/square
- **Category**: Business
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### SwiftKanban
- **Description**: Kanban software, Visualize Work, Increase Organizations Lead Time, Throughput & Productivity
- **Documentation**: https://www.digite.com/knowledge-base/swiftkanban/article/api-for-swift-kanban-web-services/#restapi
- **Category**: Business
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Tenders in Hungary
- **Description**: Get data for procurements in Hungary in JSON format
- **Documentation**: https://tenders.guru/hu/api
- **Category**: Business
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Tenders in Poland
- **Description**: Get data for procurements in Poland in JSON format
- **Documentation**: https://tenders.guru/pl/api
- **Category**: Business
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Tenders in Romania
- **Description**: Get data for procurements in Romania in JSON format
- **Documentation**: https://tenders.guru/ro/api
- **Category**: Business
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Tenders in Spain
- **Description**: Get data for procurements in Spain in JSON format
- **Documentation**: https://tenders.guru/es/api
- **Category**: Business
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Tenders in Ukraine
- **Description**: Get data for procurements in Ukraine in JSON format
- **Documentation**: https://tenders.guru/ua/api
- **Category**: Business
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Tomba email finder
- **Description**: Email Finder for B2B sales and email marketing and email verifier
- **Documentation**: https://tomba.io/api
- **Category**: Business
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Trello
- **Description**: Boards, lists and cards to help you organize and prioritize your projects
- **Documentation**: https://developers.trello.com/
- **Category**: Business
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Calendar

### Public Holidays
- **Description**: Data on national, regional, and religious holidays via API
- **Documentation**: https://www.abstractapi.com/holidays-api
- **Category**: Calendar
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Calendarific
- **Description**: Worldwide Holidays
- **Documentation**: https://calendarific.com/
- **Category**: Calendar
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Checkiday - National Holiday API
- **Description**: Industry-leading Holiday API. Over 5,000 holidays and thousands of descriptions. Trusted by the World’s leading companies
- **Documentation**: https://apilayer.com/marketplace/checkiday-api
- **Category**: Calendar
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Church Calendar
- **Description**: Catholic liturgical calendar
- **Documentation**: http://calapi.inadiutorium.cz/
- **Category**: Calendar
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Czech Namedays Calendar
- **Description**: Lookup for a name and returns nameday date
- **Documentation**: https://svatky.adresa.info
- **Category**: Calendar
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Festivo Public Holidays
- **Description**: Fastest and most advanced public holiday and observance service on the market
- **Documentation**: https://docs.getfestivo.com/docs/products/public-holidays-api/intro
- **Category**: Calendar
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Google Calendar
- **Description**: Display, create and modify Google calendar events
- **Documentation**: https://developers.google.com/google-apps/calendar/
- **Category**: Calendar
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Hebrew Calendar
- **Description**: Convert between Gregorian and Hebrew, fetch Shabbat and Holiday times, etc
- **Documentation**: https://www.hebcal.com/home/developer-apis
- **Category**: Calendar
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Holidays
- **Description**: Historical data regarding holidays
- **Documentation**: https://holidayapi.com/
- **Category**: Calendar
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### LectServe
- **Description**: Protestant liturgical calendar
- **Documentation**: http://www.lectserve.com
- **Category**: Calendar
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Nager.Date
- **Description**: Public holidays for more than 90 countries
- **Documentation**: https://date.nager.at
- **Category**: Calendar
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Namedays Calendar
- **Description**: Provides namedays for multiple countries
- **Documentation**: https://nameday.abalin.net
- **Category**: Calendar
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Non-Working Days
- **Description**: Database of ICS files for non working days
- **Documentation**: https://github.com/gadael/icsdb
- **Category**: Calendar
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Non-Working Days
- **Description**: Simple REST API for checking working, non-working or short days for Russia, CIS, USA and other
- **Documentation**: https://isdayoff.ru
- **Category**: Calendar
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Russian Calendar
- **Description**: Check if a date is a Russian holiday or not
- **Documentation**: https://github.com/egno/work-calendar
- **Category**: Calendar
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### UK Bank Holidays
- **Description**: Bank holidays in England and Wales, Scotland and Northern Ireland
- **Documentation**: https://www.gov.uk/bank-holidays.json
- **Category**: Calendar
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Cloud Storage & File Sharing

### AnonFiles
- **Description**: Upload and share your files anonymously
- **Documentation**: https://anonfiles.com/docs/api
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### BayFiles
- **Description**: Upload and share your files
- **Documentation**: https://bayfiles.com/docs/api
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Box
- **Description**: File Sharing and Storage
- **Documentation**: https://developer.box.com/
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### ddownload
- **Description**: File Sharing and Storage
- **Documentation**: https://ddownload.com/api
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Dropbox
- **Description**: File Sharing and Storage
- **Documentation**: https://www.dropbox.com/developers
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### File.io
- **Description**: Super simple file sharing, convenient, anonymous and secure
- **Documentation**: https://www.file.io
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Filestack
- **Description**: Filestack File Uploader & File Upload API
- **Documentation**: https://www.filestack.com
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### GoFile
- **Description**: Unlimited size file uploads for free
- **Documentation**: https://gofile.io/api
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Google Drive
- **Description**: File Sharing and Storage
- **Documentation**: https://developers.google.com/drive/
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Gyazo
- **Description**: Save & Share screen captures instantly
- **Documentation**: https://gyazo.com/api/docs
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Imgbb
- **Description**: Simple and quick private image sharing
- **Documentation**: https://api.imgbb.com/
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OneDrive
- **Description**: File Sharing and Storage
- **Documentation**: https://developer.microsoft.com/onedrive
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Pantry
- **Description**: Free JSON storage for small projects
- **Documentation**: https://getpantry.cloud/
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Pastebin
- **Description**: Plain Text Storage
- **Documentation**: https://pastebin.com/doc_api
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Pinata
- **Description**: IPFS Pinning Services API
- **Documentation**: https://docs.pinata.cloud/
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Quip
- **Description**: File Sharing and Storage for groups
- **Documentation**: https://quip.com/dev/automation/documentation
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Storj
- **Description**: Decentralized Open-Source Cloud Storage
- **Documentation**: https://docs.storj.io/dcs/
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### The Null Pointer
- **Description**: No-bullshit file hosting and URL shortening service
- **Documentation**: https://0x0.st
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Web3 Storage
- **Description**: File Sharing and Storage for Free with 1TB Space
- **Documentation**: https://web3.storage/
- **Category**: Cloud Storage & File Sharing
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

---

## Continuous Integration

### Azure DevOps Health
- **Description**: Resource health helps you diagnose and get support when an Azure issue impacts your resources
- **Documentation**: https://docs.microsoft.com/en-us/rest/api/resourcehealth
- **Category**: Continuous Integration
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: No

### Bitrise
- **Description**: Build tool and processes integrations to create efficient development pipelines
- **Documentation**: https://api-docs.bitrise.io/
- **Category**: Continuous Integration
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Buddy
- **Description**: The fastest continuous integration and continuous delivery platform
- **Documentation**: https://buddy.works/docs/api/getting-started/overview
- **Category**: Continuous Integration
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### CircleCI
- **Description**: Automate the software development process using continuous integration and continuous delivery
- **Documentation**: https://circleci.com/docs/api/v1-reference/
- **Category**: Continuous Integration
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Codeship
- **Description**: Codeship is a Continuous Integration Platform in the cloud
- **Documentation**: https://docs.cloudbees.com/docs/cloudbees-codeship/latest/api-overview/
- **Category**: Continuous Integration
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Travis CI
- **Description**: Sync your GitHub projects with Travis CI to test your code in minutes
- **Documentation**: https://docs.travis-ci.com/api/
- **Category**: Continuous Integration
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Cryptocurrency

### 0x
- **Description**: API for querying token and pool stats across various liquidity pools
- **Documentation**: https://0x.org/api
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### 1inch
- **Description**: API for querying decentralize exchange
- **Documentation**: https://1inch.io/api/
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Alchemy Ethereum
- **Description**: Ethereum Node-as-a-Service Provider
- **Documentation**: https://docs.alchemy.com/alchemy/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### apilayer coinlayer
- **Description**: Real-time Crypto Currency Exchange Rates
- **Documentation**: https://coinlayer.com
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Binance
- **Description**: Exchange for Trading Cryptocurrencies based in China
- **Documentation**: https://github.com/binance/binance-spot-api-docs
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Bitcambio
- **Description**: Get the list of all traded assets in the exchange
- **Documentation**: https://nova.bitcambio.com.br/api/v3/docs#a-public
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### BitcoinAverage
- **Description**: Digital Asset Price Data for the blockchain industry
- **Documentation**: https://apiv2.bitcoinaverage.com/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### BitcoinCharts
- **Description**: Financial and Technical Data related to the Bitcoin Network
- **Documentation**: https://bitcoincharts.com/about/exchanges/
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Bitfinex
- **Description**: Cryptocurrency Trading Platform
- **Documentation**: https://docs.bitfinex.com/docs
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Bitmex
- **Description**: Real-Time Cryptocurrency derivatives trading platform based in Hong Kong
- **Documentation**: https://www.bitmex.com/app/apiOverview
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Bittrex
- **Description**: Next Generation Crypto Trading Platform
- **Documentation**: https://bittrex.github.io/api/v3
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Block
- **Description**: Bitcoin Payment, Wallet & Transaction Data
- **Documentation**: https://block.io/docs/basic
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Blockchain
- **Description**: Bitcoin Payment, Wallet & Transaction Data
- **Documentation**: https://www.blockchain.com/api
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### blockfrost Cardano
- **Description**: Interaction with the Cardano mainnet and several testnets
- **Documentation**: https://blockfrost.io/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Brave NewCoin
- **Description**: Real-time and historic crypto data from more than 200+ exchanges
- **Documentation**: https://bravenewcoin.com/developers
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### BtcTurk
- **Description**: Real-time cryptocurrency data, graphs and API that allows buy&sell
- **Documentation**: https://docs.btcturk.com/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Bybit
- **Description**: Cryptocurrency data feed and algorithmic trading
- **Documentation**: https://bybit-exchange.github.io/docs/linear/#t-introduction
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### CoinAPI
- **Description**: All Currency Exchanges integrate under a single api
- **Documentation**: https://docs.coinapi.io/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Coinbase
- **Description**: Bitcoin, Bitcoin Cash, Litecoin and Ethereum Prices
- **Documentation**: https://developers.coinbase.com
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Coinbase Pro
- **Description**: Cryptocurrency Trading Platform
- **Documentation**: https://docs.pro.coinbase.com/#api
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### CoinCap
- **Description**: Real time Cryptocurrency prices through a RESTful API
- **Documentation**: https://docs.coincap.io/
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### CoinDCX
- **Description**: Cryptocurrency Trading Platform
- **Documentation**: https://docs.coindcx.com/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### CoinDesk
- **Description**: CoinDesk's Bitcoin Price Index (BPI) in multiple currencies
- **Documentation**: https://old.coindesk.com/coindesk-api/
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### CoinGecko
- **Description**: Cryptocurrency Price, Market, and Developer/Social Data
- **Documentation**: http://www.coingecko.com/api
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Coinigy
- **Description**: Interacting with Coinigy Accounts and Exchange Directly
- **Documentation**: https://coinigy.docs.apiary.io
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Coinlib
- **Description**: Crypto Currency Prices
- **Documentation**: https://coinlib.io/apidocs
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Coinlore
- **Description**: Cryptocurrencies prices, volume and more
- **Documentation**: https://www.coinlore.com/cryptocurrency-data-api
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### CoinMarketCap
- **Description**: Cryptocurrencies Prices
- **Documentation**: https://coinmarketcap.com/api/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Coinpaprika
- **Description**: Cryptocurrencies prices, volume and more
- **Documentation**: https://api.coinpaprika.com
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### CoinRanking
- **Description**: Live Cryptocurrency data
- **Documentation**: https://developers.coinranking.com/api/documentation
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Coinremitter
- **Description**: Cryptocurrencies Payment & Prices
- **Documentation**: https://coinremitter.com/docs
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### CoinStats
- **Description**: Crypto Tracker
- **Documentation**: https://documenter.getpostman.com/view/5734027/RzZ6Hzr3?version=latest
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### CryptAPI
- **Description**: Cryptocurrency Payment Processor
- **Documentation**: https://docs.cryptapi.io/
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### CryptingUp
- **Description**: Cryptocurrency data
- **Documentation**: https://www.cryptingup.com/apidoc/#introduction
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### CryptoCompare
- **Description**: Cryptocurrencies Comparison
- **Documentation**: https://www.cryptocompare.com/api#
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### CryptoMarket
- **Description**: Cryptocurrencies Trading platform
- **Documentation**: https://api.exchange.cryptomkt.com/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Cryptonator
- **Description**: Cryptocurrencies Exchange Rates
- **Documentation**: https://www.cryptonator.com/api/
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### dYdX
- **Description**: Decentralized cryptocurrency exchange
- **Documentation**: https://docs.dydx.exchange/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Ethplorer
- **Description**: Ethereum tokens, balances, addresses, history of transactions, contracts, and custom structures
- **Documentation**: https://github.com/EverexIO/Ethplorer/wiki/Ethplorer-API
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### EXMO
- **Description**: Cryptocurrencies exchange based in UK
- **Documentation**: https://documenter.getpostman.com/view/10287440/SzYXWKPi
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### FTX
- **Description**: Complete REST, websocket, and FTX APIs to suit your algorithmic trading needs
- **Documentation**: https://docs.ftx.com/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Gateio
- **Description**: API provides spot, margin and futures trading operations
- **Documentation**: https://www.gate.io/api2
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Gemini
- **Description**: Cryptocurrencies Exchange
- **Documentation**: https://docs.gemini.com/rest-api/
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Hirak Exchange Rates
- **Description**: Exchange rates between 162 currency & 300 crypto currency update each 5 min, accurate, no limits
- **Documentation**: https://rates.hirak.site/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Huobi
- **Description**: Seychelles based cryptocurrency exchange
- **Documentation**: https://huobiapi.github.io/docs/spot/v1/en/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### icy.tools
- **Description**: GraphQL based NFT API
- **Documentation**: https://developers.icy.tools/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Indodax
- **Description**: Trade your Bitcoin and other assets with rupiah
- **Documentation**: https://github.com/btcid/indodax-official-api-docs
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### INFURA Ethereum
- **Description**: Interaction with the Ethereum mainnet and several testnets
- **Documentation**: https://infura.io/product/ethereum
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Kraken
- **Description**: Cryptocurrencies Exchange
- **Documentation**: https://docs.kraken.com/rest/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### KuCoin
- **Description**: Cryptocurrency Trading Platform
- **Documentation**: https://docs.kucoin.com/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Localbitcoins
- **Description**: P2P platform to buy and sell Bitcoins
- **Documentation**: https://localbitcoins.com/api-docs/
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Mempool
- **Description**: Bitcoin API Service focusing on the transaction fee
- **Documentation**: https://mempool.space/api
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### MercadoBitcoin
- **Description**: Brazilian Cryptocurrency Information
- **Documentation**: https://www.mercadobitcoin.com.br/api-doc/
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Messari
- **Description**: Provides API endpoints for thousands of crypto assets
- **Documentation**: https://messari.io/api
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Nexchange
- **Description**: Automated cryptocurrency exchange service
- **Documentation**: https://nexchange2.docs.apiary.io/
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Yes

### Nomics
- **Description**: Historical and realtime cryptocurrency prices and market data
- **Documentation**: https://nomics.com/docs/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### NovaDax
- **Description**: NovaDAX API to access all market data, trading management endpoints
- **Documentation**: https://doc.novadax.com/en-US/#introduction
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OKEx
- **Description**: Cryptocurrency exchange based in Seychelles
- **Documentation**: https://www.okex.com/docs/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Poloniex
- **Description**: US based digital asset exchange
- **Documentation**: https://docs.poloniex.com
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Solana JSON RPC
- **Description**: Provides various endpoints to interact with the Solana Blockchain
- **Documentation**: https://docs.solana.com/developing/clients/jsonrpc-api
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Technical Analysis
- **Description**: Cryptocurrency prices and technical analysis
- **Documentation**: https://technical-analysis-api.com
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### VALR
- **Description**: Cryptocurrency Exchange based in South Africa
- **Documentation**: https://docs.valr.com/
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### WorldCoinIndex
- **Description**: Cryptocurrencies Prices
- **Documentation**: https://www.worldcoinindex.com/apiservice
- **Category**: Cryptocurrency
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ZMOK
- **Description**: Ethereum JSON RPC API and Web3 provider
- **Documentation**: https://zmok.io
- **Category**: Cryptocurrency
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Currency Exchange

### 1Forge
- **Description**: Forex currency market data
- **Documentation**: https://1forge.com/forex-data-api/api-documentation
- **Category**: Currency Exchange
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Amdoren
- **Description**: Free currency API with over 150 currencies
- **Documentation**: https://www.amdoren.com/currency-api/
- **Category**: Currency Exchange
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### apilayer fixer.io
- **Description**: Exchange rates and currency conversion
- **Documentation**: https://fixer.io
- **Category**: Currency Exchange
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Bank of Russia
- **Description**: Exchange rates and currency conversion
- **Documentation**: https://www.cbr.ru/development/SXML/
- **Category**: Currency Exchange
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Currency-api
- **Description**: Free Currency Exchange Rates API with 150+ Currencies & No Rate Limits
- **Documentation**: https://github.com/fawazahmed0/currency-api#readme
- **Category**: Currency Exchange
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### CurrencyFreaks
- **Description**: Provides current and historical currency exchange rates with free plan 1K requests/month
- **Documentation**: https://currencyfreaks.com/
- **Category**: Currency Exchange
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Currencylayer
- **Description**: Exchange rates and currency conversion
- **Documentation**: https://currencylayer.com/documentation
- **Category**: Currency Exchange
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### CurrencyScoop
- **Description**: Real-time and historical currency rates JSON API
- **Documentation**: https://currencyscoop.com/api-documentation
- **Category**: Currency Exchange
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Czech National Bank
- **Description**: A collection of exchange rates
- **Documentation**: https://www.cnb.cz/cs/financni_trhy/devizovy_trh/kurzy_devizoveho_trhu/denni_kurz.xml
- **Category**: Currency Exchange
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Economia.Awesome
- **Description**: Portuguese free currency prices and conversion with no rate limits
- **Documentation**: https://docs.awesomeapi.com.br/api-de-moedas
- **Category**: Currency Exchange
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### ExchangeRate-API
- **Description**: Free currency conversion
- **Documentation**: https://www.exchangerate-api.com
- **Category**: Currency Exchange
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Exchangerate.host
- **Description**: Free foreign exchange & crypto rates API
- **Documentation**: https://exchangerate.host
- **Category**: Currency Exchange
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Exchangeratesapi.io
- **Description**: Exchange rates with currency conversion
- **Documentation**: https://exchangeratesapi.io
- **Category**: Currency Exchange
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Frankfurter
- **Description**: Exchange rates, currency conversion and time series
- **Documentation**: https://www.frankfurter.app/docs
- **Category**: Currency Exchange
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### FreeForexAPI
- **Description**: Real-time foreign exchange rates for major currency pairs
- **Documentation**: https://freeforexapi.com/Home/Api
- **Category**: Currency Exchange
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### National Bank of Poland
- **Description**: A collection of currency exchange rates (data in XML and JSON)
- **Documentation**: http://api.nbp.pl/en.html
- **Category**: Currency Exchange
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### VATComply.com
- **Description**: Exchange rates, geolocation and VAT number validation
- **Documentation**: https://www.vatcomply.com/documentation
- **Category**: Currency Exchange
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

---

## Data Validation

### Lob.com
- **Description**: US Address Verification
- **Documentation**: https://lob.com/
- **Category**: Data Validation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Postman Echo
- **Description**: Test api server to receive and return value from HTTP method
- **Documentation**: https://www.postman-echo.com
- **Category**: Data Validation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### PurgoMalum
- **Description**: Content validator against profanity & obscenity
- **Documentation**: http://www.purgomalum.com
- **Category**: Data Validation
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### US Autocomplete
- **Description**: Enter address data quickly with real-time address suggestions
- **Documentation**: https://www.smarty.com/docs/cloud/us-autocomplete-pro-api
- **Category**: Data Validation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### US Extract
- **Description**: Extract postal addresses from any text including emails
- **Documentation**: https://www.smarty.com/products/apis/us-extract-api
- **Category**: Data Validation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### US Street Address
- **Description**: Validate and append data for any US postal address
- **Documentation**: https://www.smarty.com/docs/cloud/us-street-api
- **Category**: Data Validation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### vatlayer
- **Description**: VAT number validation
- **Documentation**: https://vatlayer.com/documentation
- **Category**: Data Validation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Development

### 24 Pull Requests
- **Description**: Project to promote open source collaboration during December
- **Documentation**: https://24pullrequests.com/api
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Screenshot
- **Description**: Take programmatic screenshots of web pages from any website
- **Documentation**: https://www.abstractapi.com/website-screenshot-api
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Agify.io
- **Description**: Estimates the age from a first name
- **Documentation**: https://agify.io
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### API Grátis
- **Description**: Multiples services and public APIs
- **Documentation**: https://apigratis.com.br/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### ApicAgent
- **Description**: Extract device details from user-agent string
- **Documentation**: https://www.apicagent.com
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### ApiFlash
- **Description**: Chrome based screenshot API for developers
- **Documentation**: https://apiflash.com/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### apilayer userstack
- **Description**: Secure User-Agent String Lookup JSON API
- **Documentation**: https://userstack.com/
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### APIs.guru
- **Description**: Wikipedia for Web APIs, OpenAPI/Swagger specs for public APIs
- **Documentation**: https://apis.guru/api-doc/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Azure DevOps
- **Description**: The Azure DevOps basic components of a REST API request/response pair
- **Documentation**: https://docs.microsoft.com/en-us/rest/api/azure/devops
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Base
- **Description**: Building quick backends
- **Documentation**: https://www.base-api.io/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Beeceptor
- **Description**: Build a mock Rest API endpoint in seconds
- **Documentation**: https://beeceptor.com/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Bitbucket
- **Description**: Bitbucket API
- **Documentation**: https://developer.atlassian.com/bitbucket/api/2/reference/
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Blague.xyz
- **Description**: La plus grande API de Blagues FR/The biggest FR jokes API
- **Documentation**: https://blague.xyz/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Blitapp
- **Description**: Schedule screenshots of web pages and sync them to your cloud
- **Documentation**: https://blitapp.com/api/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Blynk-Cloud
- **Description**: Control IoT Devices from Blynk IoT Cloud
- **Documentation**: https://blynkapi.docs.apiary.io/#
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Bored
- **Description**: Find random activities to fight boredom
- **Documentation**: https://www.boredapi.com/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Brainshop.ai
- **Description**: Make A Free A.I Brain
- **Documentation**: https://brainshop.ai/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Browshot
- **Description**: Easily make screenshots of web pages in any screen size, as any device
- **Documentation**: https://browshot.com/api/documentation
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### CDNJS
- **Description**: Library info on CDNJS
- **Documentation**: https://api.cdnjs.com/libraries/jquery
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Changelogs.md
- **Description**: Structured changelog metadata from open source projects
- **Documentation**: https://changelogs.md
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Ciprand
- **Description**: Secure random string generator
- **Documentation**: https://github.com/polarspetroll/ciprand
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Cloudflare Trace
- **Description**: Get IP Address, Timestamp, User Agent, Country Code, IATA, HTTP Version, TLS/SSL Version & More
- **Documentation**: https://github.com/fawazahmed0/cloudflare-trace-api
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Codex
- **Description**: Online Compiler for Various Languages
- **Documentation**: https://github.com/Jaagrav/CodeX
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Contentful Images
- **Description**: Used to retrieve and apply transformations to images
- **Documentation**: https://www.contentful.com/developers/docs/references/images-api/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### CORS Proxy
- **Description**: Get around the dreaded CORS error by using this proxy as a middle man
- **Documentation**: https://github.com/burhanuday/cors-proxy
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### CountAPI
- **Description**: Free and simple counting service. You can use it to track page hits and specific events
- **Documentation**: https://countapi.xyz
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Databricks
- **Description**: Service to manage your databricks account,clusters, notebooks, jobs and workspaces
- **Documentation**: https://docs.databricks.com/dev-tools/api/latest/index.html
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### DigitalOcean Status
- **Description**: Status of all DigitalOcean services
- **Documentation**: https://status.digitalocean.com/api
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Docker Hub
- **Description**: Interact with Docker Hub
- **Documentation**: https://docs.docker.com/docker-hub/api/latest/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### DomainDb Info
- **Description**: Domain name search to find all domains containing particular words/phrases/etc
- **Documentation**: https://api.domainsdb.info/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### ExtendsClass JSON Storage
- **Description**: A simple JSON store API
- **Documentation**: https://extendsclass.com/json-storage.html
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### GeekFlare
- **Description**: Provide numerous capabilities for important testing and monitoring methods for websites
- **Documentation**: https://apidocs.geekflare.com/docs/geekflare-api
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Genderize.io
- **Description**: Estimates a gender from a first name
- **Documentation**: https://genderize.io
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### GETPing
- **Description**: Trigger an email notification with a simple GET request
- **Documentation**: https://www.getping.info
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Ghost
- **Description**: Get Published content into your Website, App or other embedded media
- **Documentation**: https://ghost.org/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### GitHub
- **Description**: Make use of GitHub repositories, code and user info programmatically
- **Documentation**: https://docs.github.com/en/free-pro-team@latest/rest
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Gitlab
- **Description**: Automate GitLab interaction programmatically
- **Documentation**: https://docs.gitlab.com/ee/api/
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Gitter
- **Description**: Chat for Developers
- **Documentation**: https://developer.gitter.im/docs/welcome
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Glitterly
- **Description**: Image generation API
- **Documentation**: https://developers.glitterly.app
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Google Docs
- **Description**: API to read, write, and format Google Docs documents
- **Documentation**: https://developers.google.com/docs/api/reference/rest
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Google Firebase
- **Description**: Google's mobile application development platform that helps build, improve, and grow app
- **Documentation**: https://firebase.google.com/docs
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Google Fonts
- **Description**: Metadata for all families served by Google Fonts
- **Documentation**: https://developers.google.com/fonts/docs/developer_api
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Google Keep
- **Description**: API to read, write, and format Google Keep notes
- **Documentation**: https://developers.google.com/keep/api/reference/rest
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Google Sheets
- **Description**: API to read, write, and format Google Sheets data
- **Documentation**: https://developers.google.com/sheets/api/reference/rest
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Google Slides
- **Description**: API to read, write, and format Google Slides presentations
- **Documentation**: https://developers.google.com/slides/api/reference/rest
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Gorest
- **Description**: Online REST API for Testing and Prototyping
- **Documentation**: https://gorest.co.in/
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Hasura
- **Description**: GraphQL and REST API Engine with built in Authorization
- **Documentation**: https://hasura.io/opensource/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Heroku
- **Description**: REST API to programmatically create apps, provision add-ons and perform other task on Heroku
- **Documentation**: https://devcenter.heroku.com/articles/platform-api-reference/
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### host-t.com
- **Description**: Basic DNS query via HTTP GET request
- **Documentation**: https://host-t.com
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Host.io
- **Description**: Domains Data API for Developers
- **Documentation**: https://host.io
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### HTTP2.Pro
- **Description**: Test endpoints for client and server HTTP/2 protocol support
- **Documentation**: https://http2.pro/doc/api
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Httpbin
- **Description**: A Simple HTTP Request & Response Service
- **Documentation**: https://httpbin.org/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Httpbin Cloudflare
- **Description**: A Simple HTTP Request & Response Service with HTTP/3 Support by Cloudflare
- **Documentation**: https://cloudflare-quic.com/b/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Hunter
- **Description**: API for domain search, professional email finder, author finder and email verifier
- **Documentation**: https://hunter.io/api
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### IBM Text to Speech
- **Description**: Convert text to speech
- **Documentation**: https://cloud.ibm.com/docs/text-to-speech/getting-started.html
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Icanhazepoch
- **Description**: Get Epoch time
- **Documentation**: https://icanhazepoch.com
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Icanhazip
- **Description**: IP Address API
- **Documentation**: https://major.io/icanhazip-com-faq/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### IFTTT
- **Description**: IFTTT Connect API
- **Documentation**: https://platform.ifttt.com/docs/connect_api
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Image-Charts
- **Description**: Generate charts, QR codes and graph images
- **Documentation**: https://documentation.image-charts.com/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### import.io
- **Description**: Retrieve structured data from a website or RSS feed
- **Documentation**: http://api.docs.import.io/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ip-fast.com
- **Description**: IP address, country and city
- **Documentation**: https://ip-fast.com/docs/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### IP2WHOIS Information Lookup
- **Description**: WHOIS domain name lookup
- **Documentation**: https://www.ip2whois.com/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ipfind.io
- **Description**: Geographic location of an IP address or any domain name along with some other useful information
- **Documentation**: https://ipfind.io
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### IPify
- **Description**: A simple IP Address API
- **Documentation**: https://www.ipify.org/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### IPinfo
- **Description**: Another simple IP Address API
- **Documentation**: https://ipinfo.io/developers
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### jsDelivr
- **Description**: Package info and download stats on jsDelivr CDN
- **Documentation**: https://github.com/jsdelivr/data.jsdelivr.com
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### JSON 2 JSONP
- **Description**: Convert JSON to JSONP (on-the-fly) for easy cross-domain data requests using client-side JavaScript
- **Documentation**: https://json2jsonp.com/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### JSONbin.io
- **Description**: Free JSON storage service. Ideal for small scale Web apps, Websites and Mobile apps
- **Documentation**: https://jsonbin.io
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Kroki
- **Description**: Creates diagrams from textual descriptions
- **Documentation**: https://kroki.io
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### License-API
- **Description**: Unofficial REST API for choosealicense.com
- **Documentation**: https://github.com/cmccandless/license-api/blob/master/README.md
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Logs.to
- **Description**: Generate logs
- **Documentation**: https://logs.to/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Lua Decompiler
- **Description**: Online Lua 5.1 Decompiler
- **Documentation**: https://lua-decompiler.ferib.dev/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### MAC address vendor lookup
- **Description**: Retrieve vendor details and other information regarding a given MAC address or an OUI
- **Documentation**: https://macaddress.io/api
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Micro DB
- **Description**: Simple database service
- **Documentation**: https://m3o.com/db
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### MicroENV
- **Description**: Fake Rest API for developers
- **Documentation**: https://microenv.com/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Mocky
- **Description**: Mock user defined test JSON for REST API endpoints
- **Documentation**: https://designer.mocky.io/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### MY IP
- **Description**: Get IP address information
- **Documentation**: https://www.myip.com/api-docs/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Nationalize.io
- **Description**: Estimate the nationality of a first name
- **Documentation**: https://nationalize.io
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Netlify
- **Description**: Netlify is a hosting service for the programmable web
- **Documentation**: https://docs.netlify.com/api/get-started/
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### NetworkCalc
- **Description**: Network calculators, including subnets, DNS, binary, and security tools
- **Documentation**: https://networkcalc.com/api/docs
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### npm Registry
- **Description**: Query information about your favorite Node.js libraries programatically
- **Documentation**: https://github.com/npm/registry/blob/master/docs/REGISTRY-API.md
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### OneSignal
- **Description**: Self-serve customer engagement solution for Push Notifications, Email, SMS & In-App
- **Documentation**: https://documentation.onesignal.com/docs/onesignal-api
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Page Rank
- **Description**: API for calculating and comparing metrics of different websites using Page Rank algorithm
- **Documentation**: https://www.domcop.com/openpagerank/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OpenAPIHub
- **Description**: The All-in-one API Platform
- **Documentation**: https://hub.openapihub.com/
- **Category**: Development
- **Auth Type**: X-Mashape-Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OpenGraphr
- **Description**: Really simple API to retrieve Open Graph data from an URL
- **Documentation**: https://opengraphr.com/docs/1.0/overview
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### oyyi
- **Description**: API for Fake Data, image/video conversion, optimization, pdf optimization and thumbnail generation
- **Documentation**: https://oyyi.xyz/docs/1.0
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### PageCDN
- **Description**: Public API for javascript, css and font libraries on PageCDN
- **Documentation**: https://pagecdn.com/docs/public-api
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Postman
- **Description**: Tool for testing APIs
- **Documentation**: https://www.postman.com/postman/workspace/postman-public-workspace/documentation/12959542-c8142d51-e97c-46b6-bd77-52bb66712c9a
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ProxyCrawl
- **Description**: Scraping and crawling anticaptcha service
- **Documentation**: https://proxycrawl.com
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ProxyKingdom
- **Description**: Rotating Proxy API that produces a working proxy on every request
- **Documentation**: https://proxykingdom.com
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Pusher Beams
- **Description**: Push notifications for Android & iOS
- **Documentation**: https://pusher.com/beams
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### QR code
- **Description**: Create an easy to read QR code and URL shortener
- **Documentation**: https://www.qrtag.net/api/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### QR code
- **Description**: Generate and decode / read QR code graphics
- **Documentation**: http://goqr.me/api/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Qrcode Monkey
- **Description**: Integrate custom and unique looking QR codes into your system or workflow
- **Documentation**: https://www.qrcode-monkey.com/qr-code-api-with-logo/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### QuickChart
- **Description**: Generate chart and graph images
- **Documentation**: https://quickchart.io/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Random Stuff
- **Description**: Can be used to get AI Response, jokes, memes, and much more at lightning-fast speed
- **Documentation**: https://api-docs.pgamerx.com/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Rejax
- **Description**: Reverse AJAX service to notify clients
- **Documentation**: https://rejax.io/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### ReqRes
- **Description**: A hosted REST-API ready to respond to your AJAX requests
- **Documentation**: https://reqres.in/ 
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### RSS feed to JSON
- **Description**: Returns RSS feed in JSON format using feed URL
- **Documentation**: https://rss-to-json-serverless-api.vercel.app
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### SavePage.io
- **Description**: A free, RESTful API used to screenshot any desktop, or mobile website
- **Documentation**: https://www.savepage.io
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### ScrapeNinja
- **Description**: Scraping API with Chrome fingerprint and residential proxies
- **Documentation**: https://scrapeninja.net
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ScraperApi
- **Description**: Easily build scalable web scrapers
- **Documentation**: https://www.scraperapi.com
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### scraperBox
- **Description**: Undetectable web scraping API
- **Documentation**: https://scraperbox.com/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### scrapestack
- **Description**: Real-time, Scalable Proxy & Web Scraping REST API
- **Documentation**: https://scrapestack.com/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ScrapingAnt
- **Description**: Headless Chrome scraping with a simple API
- **Documentation**: https://scrapingant.com
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ScrapingDog
- **Description**: Proxy API for Web scraping
- **Documentation**: https://www.scrapingdog.com/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ScreenshotAPI.net
- **Description**: Create pixel-perfect website screenshots
- **Documentation**: https://screenshotapi.net/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Serialif Color
- **Description**: Color conversion, complementary, grayscale and contrasted text
- **Documentation**: https://color.serialif.com/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### serpstack
- **Description**: Real-Time & Accurate Google Search Results API
- **Documentation**: https://serpstack.com/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Sheetsu
- **Description**: Easy google sheets integration
- **Documentation**: https://sheetsu.com/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### SHOUTCLOUD
- **Description**: ALL-CAPS AS A SERVICE
- **Documentation**: http://shoutcloud.io/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Sonar
- **Description**: Project Sonar DNS Enumeration API
- **Documentation**: https://github.com/Cgboal/SonarSearch
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### SonarQube
- **Description**: SonarQube REST APIs to detect bugs, code smells & security vulnerabilities
- **Documentation**: https://sonarcloud.io/web_api
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### StackExchange
- **Description**: Q&A forum for developers
- **Documentation**: https://api.stackexchange.com/
- **Category**: Development
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Statically
- **Description**: A free CDN for developers
- **Documentation**: https://statically.io/
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Supportivekoala
- **Description**: Autogenerate images with template
- **Documentation**: https://developers.supportivekoala.com/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Tyk
- **Description**: Api and service management platform
- **Documentation**: https://tyk.io/open-source/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Wandbox
- **Description**: Code compiler supporting 35+ languages mentioned at wandbox.org
- **Documentation**: https://github.com/melpon/wandbox/blob/master/kennel2/API.rst
- **Category**: Development
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### WebScraping.AI
- **Description**: Web Scraping API with built-in proxies and JS rendering
- **Documentation**: https://webscraping.ai/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### ZenRows
- **Description**: Web Scraping API that bypasses anti-bot solutions while offering JS rendering, and rotating proxies
- **Documentation**: https://www.zenrows.com/
- **Category**: Development
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Dictionaries

### Chinese Character Web
- **Description**: Chinese character definitions and pronunciations
- **Documentation**: http://ccdb.hemiola.com/
- **Category**: Dictionaries
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: No

### Chinese Text Project
- **Description**: Online open-access digital library for pre-modern Chinese texts
- **Documentation**: https://ctext.org/tools/api
- **Category**: Dictionaries
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Collins
- **Description**: Bilingual Dictionary and Thesaurus Data
- **Documentation**: https://api.collinsdictionary.com/api/v1/documentation/html/
- **Category**: Dictionaries
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Free Dictionary
- **Description**: Definitions, phonetics, pronounciations, parts of speech, examples, synonyms
- **Documentation**: https://dictionaryapi.dev/
- **Category**: Dictionaries
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Indonesia Dictionary
- **Description**: Indonesia dictionary many words
- **Documentation**: https://new-kbbi-api.herokuapp.com/
- **Category**: Dictionaries
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Lingua Robot
- **Description**: Word definitions, pronunciations, synonyms, antonyms and others
- **Documentation**: https://www.linguarobot.io
- **Category**: Dictionaries
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Merriam-Webster
- **Description**: Dictionary and Thesaurus Data
- **Documentation**: https://dictionaryapi.com/
- **Category**: Dictionaries
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OwlBot
- **Description**: Definitions with example sentence and photo if available
- **Documentation**: https://owlbot.info/
- **Category**: Dictionaries
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Oxford
- **Description**: Dictionary Data
- **Documentation**: https://developer.oxforddictionaries.com/
- **Category**: Dictionaries
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Synonyms
- **Description**: Synonyms, thesaurus and antonyms information for any given word
- **Documentation**: https://www.synonyms.com/synonyms_api.php
- **Category**: Dictionaries
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Wiktionary
- **Description**: Collaborative dictionary data
- **Documentation**: https://en.wiktionary.org/w/api.php
- **Category**: Dictionaries
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Wordnik
- **Description**: Dictionary Data
- **Documentation**: https://developer.wordnik.com
- **Category**: Dictionaries
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Words
- **Description**: Definitions and synonyms for more than 150,000 words
- **Documentation**: https://www.wordsapi.com/docs/
- **Category**: Dictionaries
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Documents & Productivity

### Airtable
- **Description**: Integrate with Airtable
- **Documentation**: https://airtable.com/api
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Api2Convert
- **Description**: Online File Conversion API
- **Documentation**: https://www.api2convert.com/
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### apilayer pdflayer
- **Description**: HTML/URL to PDF
- **Documentation**: https://pdflayer.com
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Asana
- **Description**: Programmatic access to all data in your asana system
- **Documentation**: https://developers.asana.com/docs
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### ClickUp
- **Description**: ClickUp is a robust, cloud-based project management tool for boosting productivity
- **Documentation**: https://clickup.com/api
- **Category**: Documents & Productivity
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Clockify
- **Description**: Clockify's REST-based API can be used to push/pull data to/from it & integrate it with other systems
- **Documentation**: https://clockify.me/developers-api 
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### CloudConvert
- **Description**: Online file converter for audio, video, document, ebook, archive, image, spreadsheet, presentation
- **Documentation**: https://cloudconvert.com/api/v2
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Cloudmersive Document and Data Conversion
- **Description**: HTML/URL to PDF/PNG, Office documents to PDF, image conversion
- **Documentation**: https://cloudmersive.com/convert-api
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Code::Stats
- **Description**: Automatic time tracking for programmers
- **Documentation**: https://codestats.net/api-docs
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### CraftMyPDF
- **Description**: Generate PDF documents from templates with a drop-and-drop editor and a simple API
- **Documentation**: https://craftmypdf.com
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Flowdash
- **Description**: Automate business workflows
- **Documentation**: https://docs.flowdash.com/docs/api-introduction
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Html2PDF
- **Description**: HTML/URL to PDF
- **Documentation**: https://html2pdf.app/
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### iLovePDF
- **Description**: Convert, merge, split, extract text and add page numbers for PDFs. Free for 250 documents/month
- **Documentation**: https://developer.ilovepdf.com/
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### JIRA
- **Description**: JIRA is a proprietary issue tracking product that allows bug tracking and agile project management
- **Documentation**: https://developer.atlassian.com/server/jira/platform/rest-apis/
- **Category**: Documents & Productivity
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Mattermost
- **Description**: An open source platform for developer collaboration
- **Documentation**: https://api.mattermost.com/
- **Category**: Documents & Productivity
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Mercury
- **Description**: Web parser
- **Documentation**: https://mercury.postlight.com/web-parser/
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Monday
- **Description**: Programmatically access and update data inside a monday.com account
- **Documentation**: https://api.developer.monday.com/docs
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Notion
- **Description**: Integrate with Notion
- **Documentation**: https://developers.notion.com/docs/getting-started
- **Category**: Documents & Productivity
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### PandaDoc
- **Description**: DocGen and eSignatures API
- **Documentation**: https://developers.pandadoc.com
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Pocket
- **Description**: Bookmarking service
- **Documentation**: https://getpocket.com/developer/
- **Category**: Documents & Productivity
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Podio
- **Description**: File sharing and productivity
- **Documentation**: https://developers.podio.com
- **Category**: Documents & Productivity
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### PrexView
- **Description**: Data from XML or JSON to PDF, HTML or Image
- **Documentation**: https://prexview.com
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Restpack
- **Description**: Provides screenshot, HTML to PDF and content extraction APIs
- **Documentation**: https://restpack.io/
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Todoist
- **Description**: Todo Lists
- **Documentation**: https://developer.todoist.com
- **Category**: Documents & Productivity
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Smart Image Enhancement API
- **Description**: Performs image upscaling by adding detail to images through multiple super-resolution algorithms
- **Documentation**: https://apilayer.com/marketplace/image_enhancement-api
- **Category**: Documents & Productivity
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Vector Express v2.0
- **Description**: Free vector file converting API
- **Documentation**: https://vector.express
- **Category**: Documents & Productivity
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### WakaTime
- **Description**: Automated time tracking leaderboards for programmers
- **Documentation**: https://wakatime.com/developers
- **Category**: Documents & Productivity
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Zube
- **Description**: Full stack project management
- **Documentation**: https://zube.io/docs/api
- **Category**: Documents & Productivity
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Email

### apilayer mailboxlayer
- **Description**: Email address validation
- **Documentation**: https://mailboxlayer.com
- **Category**: Email
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Email Validation
- **Description**: Validate email addresses for deliverability and spam
- **Documentation**: https://www.abstractapi.com/email-verification-validation-api
- **Category**: Email
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Cloudmersive Validate
- **Description**: Validate email addresses, phone numbers, VAT numbers and domain names
- **Documentation**: https://cloudmersive.com/validate-api
- **Category**: Email
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Disify
- **Description**: Validate and detect disposable and temporary email addresses
- **Documentation**: https://www.disify.com/
- **Category**: Email
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### DropMail
- **Description**: GraphQL API for creating and managing ephemeral e-mail inboxes
- **Documentation**: https://dropmail.me/api/#live-demo
- **Category**: Email
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### EVA
- **Description**: Validate email addresses
- **Documentation**: https://eva.pingutil.com/
- **Category**: Email
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Guerrilla Mail
- **Description**: Disposable temporary Email addresses
- **Documentation**: https://www.guerrillamail.com/GuerrillaMailAPI.html
- **Category**: Email
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### ImprovMX
- **Description**: API for free email forwarding service
- **Documentation**: https://improvmx.com/api
- **Category**: Email
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Kickbox
- **Description**: Email verification API
- **Documentation**: https://open.kickbox.com/
- **Category**: Email
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### mail.gw
- **Description**: 10 Minute Mail
- **Documentation**: https://docs.mail.gw
- **Category**: Email
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### mail.tm
- **Description**: Temporary Email Service
- **Documentation**: https://docs.mail.tm
- **Category**: Email
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### MailboxValidator
- **Description**: Validate email address to improve deliverability
- **Documentation**: https://www.mailboxvalidator.com/api-email-free
- **Category**: Email
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### MailCheck.ai
- **Description**: Prevent users to sign up with temporary email addresses
- **Documentation**: https://www.mailcheck.ai/#documentation
- **Category**: Email
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Mailtrap
- **Description**: A service for the safe testing of emails sent from the development and staging environments
- **Documentation**: https://mailtrap.docs.apiary.io/#
- **Category**: Email
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Sendgrid
- **Description**: A cloud-based SMTP provider that allows you to send emails without having to maintain email servers
- **Documentation**: https://docs.sendgrid.com/api-reference/
- **Category**: Email
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Sendinblue
- **Description**: A service that provides solutions relating to marketing and/or transactional email and/or SMS
- **Documentation**: https://developers.sendinblue.com/docs
- **Category**: Email
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Verifier
- **Description**: Verifies that a given email is real
- **Documentation**: https://verifier.meetchopra.com/docs#/
- **Category**: Email
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

---

## Entertainment

### chucknorris.io
- **Description**: JSON API for hand curated Chuck Norris jokes
- **Documentation**: https://api.chucknorris.io
- **Category**: Entertainment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Corporate Buzz Words
- **Description**: REST API for Corporate Buzz Words
- **Documentation**: https://github.com/sameerkumar18/corporate-bs-generator-api
- **Category**: Entertainment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Excuser
- **Description**: Get random excuses for various situations
- **Documentation**: https://excuser.herokuapp.com/
- **Category**: Entertainment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Fun Fact
- **Description**: A simple HTTPS api that can randomly select and return a fact from the FFA database
- **Documentation**: https://api.aakhilv.me
- **Category**: Entertainment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Imgflip
- **Description**: Gets an array of popular memes
- **Documentation**: https://imgflip.com/api
- **Category**: Entertainment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Meme Maker
- **Description**: REST API for create your own meme
- **Documentation**: https://mememaker.github.io/API/
- **Category**: Entertainment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### NaMoMemes
- **Description**: Memes on Narendra Modi
- **Documentation**: https://github.com/theIYD/NaMoMemes
- **Category**: Entertainment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Random Useless Facts
- **Description**: Get useless, but true facts
- **Documentation**: https://uselessfacts.jsph.pl/
- **Category**: Entertainment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Techy
- **Description**: JSON and Plaintext API for tech-savvy sounding phrases
- **Documentation**: https://techy-api.vercel.app/
- **Category**: Entertainment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Yo Momma Jokes
- **Description**: REST API for Yo Momma Jokes
- **Documentation**: https://github.com/beanboi7/yomomma-apiv2
- **Category**: Entertainment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Environment

### BreezoMeter Pollen
- **Description**: Daily Forecast pollen conditions data for a specific location
- **Documentation**: https://docs.breezometer.com/api-documentation/pollen-api/v2/
- **Category**: Environment
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Carbon Interface
- **Description**: API to calculate carbon (C02) emissions estimates for common C02 emitting activities
- **Documentation**: https://docs.carboninterface.com/
- **Category**: Environment
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Climatiq
- **Description**: Calculate the environmental footprint created by a broad range of emission-generating activities
- **Documentation**: https://docs.climatiq.io
- **Category**: Environment
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Cloverly
- **Description**: API calculates the impact of common carbon-intensive activities in real time
- **Documentation**: https://www.cloverly.com/carbon-offset-documentation
- **Category**: Environment
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### CO2 Offset
- **Description**: API calculates and validates the carbon footprint
- **Documentation**: https://co2offset.io/api.html
- **Category**: Environment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Danish data service Energi
- **Description**: Open energy data from Energinet to society
- **Documentation**: https://www.energidataservice.dk/
- **Category**: Environment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### GrünstromIndex
- **Description**: Green Power Index for Germany (Grünstromindex/GSI)
- **Documentation**: https://gruenstromindex.de/
- **Category**: Environment
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Yes

### IQAir
- **Description**: Air quality and weather data
- **Documentation**: https://www.iqair.com/air-pollution-data-api
- **Category**: Environment
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Luchtmeetnet
- **Description**: Predicted and actual air quality components for The Netherlands (RIVM)
- **Documentation**: https://api-docs.luchtmeetnet.nl/
- **Category**: Environment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### National Grid ESO
- **Description**: Open data from Great Britain’s Electricity System Operator
- **Documentation**: https://data.nationalgrideso.com/
- **Category**: Environment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### OpenAQ
- **Description**: Open air quality data
- **Documentation**: https://docs.openaq.org/
- **Category**: Environment
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### PM2.5 Open Data Portal
- **Description**: Open low-cost PM2.5 sensor data
- **Documentation**: https://pm25.lass-net.org/#apis
- **Category**: Environment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### PM25.in
- **Description**: Air quality of China
- **Documentation**: http://www.pm25.in/api_doc
- **Category**: Environment
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### PVWatts
- **Description**: Energy production photovoltaic (PV) energy systems
- **Documentation**: https://developer.nrel.gov/docs/solar/pvwatts/v6/
- **Category**: Environment
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Srp Energy
- **Description**: Hourly usage energy report for Srp customers
- **Documentation**: https://srpenergy-api-client-python.readthedocs.io/en/latest/api.html
- **Category**: Environment
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### UK Carbon Intensity
- **Description**: The Official Carbon Intensity API for Great Britain developed by National Grid
- **Documentation**: https://carbon-intensity.github.io/api-definitions/#carbon-intensity-api-v1-0-0
- **Category**: Environment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Website Carbon
- **Description**: API to estimate the carbon footprint of loading web pages
- **Documentation**: https://api.websitecarbon.com/
- **Category**: Environment
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Events

### Eventbrite
- **Description**: Find events
- **Documentation**: https://www.eventbrite.com/platform/api/
- **Category**: Events
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### SeatGeek
- **Description**: Search events, venues and performers
- **Documentation**: https://platform.seatgeek.com/
- **Category**: Events
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Ticketmaster
- **Description**: Search events, attractions, or venues
- **Documentation**: http://developer.ticketmaster.com/products-and-docs/apis/getting-started/
- **Category**: Events
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Finance

### VAT Validation
- **Description**: Validate VAT numbers and calculate VAT rates
- **Documentation**: https://www.abstractapi.com/vat-validation-rates-api
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Aletheia
- **Description**: Insider trading data, earnings call analysis, financial statements, and more
- **Documentation**: https://aletheiaapi.com/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Alpaca
- **Description**: Realtime and historical market data on all US equities and ETFs
- **Documentation**: https://alpaca.markets/docs/api-documentation/api-v2/market-data/alpaca-data-api-v2/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Alpha Vantage
- **Description**: Realtime and historical stock data
- **Documentation**: https://www.alphavantage.co/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### apilayer marketstack
- **Description**: Real-Time, Intraday & Historical Market Data API
- **Documentation**: https://marketstack.com/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Banco do Brasil
- **Description**: All Banco do Brasil financial transaction APIs
- **Documentation**: https://developers.bb.com.br/home
- **Category**: Finance
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Bank Data API
- **Description**: Instant IBAN and SWIFT number validation across the globe
- **Documentation**: https://apilayer.com/marketplace/bank_data-api
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Billplz
- **Description**: Payment platform
- **Documentation**: https://www.billplz.com/api
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Binlist
- **Description**: Public access to a database of IIN/BIN information
- **Documentation**: https://binlist.net/
- **Category**: Finance
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Boleto.Cloud
- **Description**: A api to generate boletos in Brazil
- **Documentation**: https://boleto.cloud/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Citi
- **Description**: All Citigroup account and statement data APIs
- **Documentation**: https://sandbox.developerhub.citi.com/api-catalog-list
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Econdb
- **Description**: Global macroeconomic data
- **Documentation**: https://www.econdb.com/api/
- **Category**: Finance
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Fed Treasury
- **Description**: U.S. Department of the Treasury Data
- **Documentation**: https://fiscaldata.treasury.gov/api-documentation/
- **Category**: Finance
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Finage
- **Description**: Finage is a stock, currency, cryptocurrency, indices, and ETFs real-time & historical data provider
- **Documentation**: https://finage.co.uk
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Financial Modeling Prep
- **Description**: Realtime and historical stock data
- **Documentation**: https://site.financialmodelingprep.com/developer/docs
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Finnhub
- **Description**: Real-Time RESTful APIs and Websocket for Stocks, Currencies, and Crypto
- **Documentation**: https://finnhub.io/docs/api
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### FRED
- **Description**: Economic data from the Federal Reserve Bank of St. Louis
- **Documentation**: https://fred.stlouisfed.org/docs/api/fred/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Front Accounting APIs
- **Description**: Front accounting is multilingual and multicurrency software for small businesses
- **Documentation**: https://frontaccounting.com/fawiki/index.php?n=Devel.SimpleAPIModule
- **Category**: Finance
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Hotstoks
- **Description**: Stock market data powered by SQL
- **Documentation**: https://hotstoks.com?utm_source=public-apis
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### IEX Cloud
- **Description**: Realtime & Historical Stock and Market Data
- **Documentation**: https://iexcloud.io/docs/api/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### IG
- **Description**: Spreadbetting and CFD Market Data
- **Documentation**: https://labs.ig.com/gettingstarted
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Indian Mutual Fund
- **Description**: Get complete history of India Mutual Funds Data
- **Documentation**: https://www.mfapi.in/
- **Category**: Finance
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Intrinio
- **Description**: A wide selection of financial data feeds
- **Documentation**: https://intrinio.com/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Klarna
- **Description**: Klarna payment and shopping service
- **Documentation**: https://docs.klarna.com/klarna-payments/api/payments-api/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### MercadoPago
- **Description**: Mercado Pago API reference - all the information you need to develop your integrations
- **Documentation**: https://www.mercadopago.com.br/developers/es/reference
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Mono
- **Description**: Connect with users’ bank accounts and access transaction data in Africa
- **Documentation**: https://mono.co/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Moov
- **Description**: The Moov API makes it simple for platforms to send, receive, and store money
- **Documentation**: https://docs.moov.io/api/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Nordigen
- **Description**: Connect to bank accounts using official bank APIs and get raw transaction data
- **Documentation**: https://nordigen.com/en/account_information_documenation/integration/quickstart_guide/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OpenFIGI
- **Description**: Equity, index, futures, options symbology from Bloomberg LP
- **Documentation**: https://www.openfigi.com/api
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Plaid
- **Description**: Connect with user's bank accounts and access transaction data
- **Documentation**: https://www.plaid.com/docs
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: YES
- **CORS**: 

### Polygon
- **Description**: Historical stock market data
- **Documentation**: https://polygon.io/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Portfolio Optimizer
- **Description**: Portfolio analysis and optimization
- **Documentation**: https://portfoliooptimizer.io/
- **Category**: Finance
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Razorpay IFSC
- **Description**: Indian Financial Systems Code (Bank Branch Codes)
- **Documentation**: https://razorpay.com/docs/
- **Category**: Finance
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Real Time Finance
- **Description**: Websocket API to access realtime stock data
- **Documentation**: https://github.com/Real-time-finance/finance-websocket-API/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### SEC EDGAR Data
- **Description**: API to access annual reports of public US companies
- **Documentation**: https://www.sec.gov/edgar/sec-api-documentation
- **Category**: Finance
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### SmartAPI
- **Description**: Gain access to set of <SmartAPI> and create end-to-end broking services
- **Documentation**: https://smartapi.angelbroking.com/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### StockData
- **Description**: Real-Time, Intraday & Historical Market Data, News and Sentiment API
- **Documentation**: https://www.StockData.org
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Styvio
- **Description**: Realtime and historical stock data and current stock sentiment
- **Documentation**: https://www.Styvio.com
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Tax Data API
- **Description**: Instant VAT number and tax validation across the globe
- **Documentation**: https://apilayer.com/marketplace/tax_data-api
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unkown

### Tradier
- **Description**: US equity/option market data (delayed, intraday, historical)
- **Documentation**: https://developer.tradier.com
- **Category**: Finance
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Twelve Data
- **Description**: Stock market data (real-time & historical)
- **Documentation**: https://twelvedata.com/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### WallstreetBets
- **Description**: WallstreetBets Stock Comments Sentiment Analysis
- **Documentation**: https://dashboard.nbshare.io/apps/reddit/api/
- **Category**: Finance
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Yahoo Finance
- **Description**: Real time low latency Yahoo Finance API for stock market, crypto currencies, and currency exchange
- **Documentation**: https://www.yahoofinanceapi.com/
- **Category**: Finance
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### YNAB
- **Description**: Budgeting & Planning
- **Documentation**: https://api.youneedabudget.com/
- **Category**: Finance
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Zoho Books
- **Description**: Online accounting software, built for your business
- **Documentation**: https://www.zoho.com/books/api/v3/
- **Category**: Finance
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Food & Drink

### BaconMockup
- **Description**: Resizable bacon placeholder images
- **Documentation**: https://baconmockup.com/
- **Category**: Food & Drink
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Chomp
- **Description**: Data about various grocery products and foods
- **Documentation**: https://chompthis.com/api/
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Coffee
- **Description**: Random pictures of coffee
- **Documentation**: https://coffee.alexflipnote.dev/
- **Category**: Food & Drink
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Edamam nutrition
- **Description**: Nutrition Analysis
- **Documentation**: https://developer.edamam.com/edamam-docs-nutrition-api
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Edamam recipes
- **Description**: Recipe Search
- **Documentation**: https://developer.edamam.com/edamam-docs-recipe-api
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Foodish
- **Description**: Random pictures of food dishes
- **Documentation**: https://github.com/surhud004/Foodish#readme
- **Category**: Food & Drink
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Fruityvice
- **Description**: Data about all kinds of fruit
- **Documentation**: https://www.fruityvice.com
- **Category**: Food & Drink
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Kroger
- **Description**: Supermarket Data
- **Documentation**: https://developer.kroger.com/reference
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### LCBO
- **Description**: Alcohol
- **Documentation**: https://lcboapi.com/
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Brewery DB
- **Description**: Breweries, Cideries and Craft Beer Bottle Shops
- **Documentation**: https://www.openbrewerydb.org
- **Category**: Food & Drink
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Open Food Facts
- **Description**: Food Products Database
- **Documentation**: https://world.openfoodfacts.org/data
- **Category**: Food & Drink
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### PunkAPI
- **Description**: Brewdog Beer Recipes
- **Documentation**: https://punkapi.com/
- **Category**: Food & Drink
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Rustybeer
- **Description**: Beer brewing tools
- **Documentation**: https://rustybeer.herokuapp.com/
- **Category**: Food & Drink
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Spoonacular
- **Description**: Recipes, Food Products, and Meal Planning
- **Documentation**: https://spoonacular.com/food-api
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Systembolaget
- **Description**: Govornment owned liqour store in Sweden
- **Documentation**: https://api-portal.systembolaget.se
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### TacoFancy
- **Description**: Community-driven taco database
- **Documentation**: https://github.com/evz/tacofancy-api
- **Category**: Food & Drink
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Tasty
- **Description**: API to query data about recipe, plan, ingredients
- **Documentation**: https://rapidapi.com/apidojo/api/tasty/
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### The Report of the Week
- **Description**: Food & Drink Reviews
- **Documentation**: https://github.com/andyklimczak/TheReportOfTheWeek-API
- **Category**: Food & Drink
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### TheCocktailDB
- **Description**: Cocktail Recipes
- **Documentation**: https://www.thecocktaildb.com/api.php
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### TheMealDB
- **Description**: Meal Recipes
- **Documentation**: https://www.themealdb.com/api.php
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Untappd
- **Description**: Social beer sharing
- **Documentation**: https://untappd.com/api/docs
- **Category**: Food & Drink
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### What's on the menu?
- **Description**: NYPL human-transcribed historical menu collection
- **Documentation**: http://nypl.github.io/menus-api/
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### WhiskyHunter
- **Description**: Past online whisky auctions statistical data
- **Documentation**: https://whiskyhunter.net/api/
- **Category**: Food & Drink
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Zestful
- **Description**: Parse recipe ingredients
- **Documentation**: https://zestfuldata.com/
- **Category**: Food & Drink
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

---

## Games & Comics

### Age of Empires II
- **Description**: Get information about Age of Empires II resources
- **Documentation**: https://age-of-empires-2-api.herokuapp.com
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### AmiiboAPI
- **Description**: Nintendo Amiibo Information
- **Documentation**: https://amiiboapi.com/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Animal Crossing: New Horizons
- **Description**: API for critters, fossils, art, music, furniture and villagers
- **Documentation**: http://acnhapi.com/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Autochess VNG
- **Description**: Rest Api for Autochess VNG
- **Documentation**: https://github.com/didadadida93/autochess-vng-api
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Barter.VG
- **Description**: Provides information about Game, DLC, Bundles, Giveaways, Trading
- **Documentation**: https://github.com/bartervg/barter.vg/wiki
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Battle.net
- **Description**: Diablo III, Hearthstone, StarCraft II and World of Warcraft game data APIs
- **Documentation**: https://develop.battle.net/documentation/guides/getting-started
- **Category**: Games & Comics
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Board Game Geek
- **Description**: Board games, RPG and videogames
- **Documentation**: https://boardgamegeek.com/wiki/page/BGG_XML_API2
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Brawl Stars
- **Description**: Brawl Stars Game Information
- **Documentation**: https://developer.brawlstars.com
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Bugsnax
- **Description**: Get information about Bugsnax
- **Documentation**: https://www.bugsnaxapi.com/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### CheapShark
- **Description**: Steam/PC Game Prices and Deals
- **Documentation**: https://www.cheapshark.com/api
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Chess.com
- **Description**: Chess.com read-only REST API
- **Documentation**: https://www.chess.com/news/view/published-data-api
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Chuck Norris Database
- **Description**: Jokes
- **Documentation**: http://www.icndb.com/api/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Clash of Clans
- **Description**: Clash of Clans Game Information
- **Documentation**: https://developer.clashofclans.com
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Clash Royale
- **Description**: Clash Royale Game Information
- **Documentation**: https://developer.clashroyale.com
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Comic Vine
- **Description**: Comics
- **Documentation**: https://comicvine.gamespot.com/api/documentation
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Crafatar
- **Description**: API for Minecraft skins and faces
- **Documentation**: https://crafatar.com
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Cross Universe
- **Description**: Cross Universe Card Data
- **Documentation**: https://crossuniverse.psychpsyo.com/apiDocs.html
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Deck of Cards
- **Description**: Deck of Cards
- **Documentation**: http://deckofcardsapi.com/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Destiny The Game
- **Description**: Bungie Platform API
- **Documentation**: https://bungie-net.github.io/multi/index.html
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Digimon Information
- **Description**: Provides information about digimon creatures
- **Documentation**: https://digimon-api.vercel.app/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Digimon TCG
- **Description**: Search for Digimon cards in digimoncard.io
- **Documentation**: https://documenter.getpostman.com/view/14059948/TzecB4fH
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Disney
- **Description**: Information of Disney characters
- **Documentation**: https://disneyapi.dev
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Dota 2
- **Description**: Provides information about Player stats , Match stats, Rankings for Dota 2
- **Documentation**: https://docs.opendota.com/
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Dungeons and Dragons
- **Description**: Reference for 5th edition spells, classes, monsters, and more
- **Documentation**: https://www.dnd5eapi.co/docs/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: No

### Dungeons and Dragons (Alternate)
- **Description**: Includes all monsters and spells from the SRD (System Reference Document) as well as a search API
- **Documentation**: https://open5e.com/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Eve Online
- **Description**: Third-Party Developer Documentation
- **Documentation**: https://esi.evetech.net/ui
- **Category**: Games & Comics
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### FFXIV Collect
- **Description**: Final Fantasy XIV data on collectables
- **Documentation**: https://ffxivcollect.com/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### FIFA Ultimate Team
- **Description**: FIFA Ultimate Team items API
- **Documentation**: https://www.easports.com/fifa/ultimate-team/api/fut/item
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Final Fantasy XIV
- **Description**: Final Fantasy XIV Game data API
- **Documentation**: https://xivapi.com/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Fortnite
- **Description**: Fortnite Stats
- **Documentation**: https://fortnitetracker.com/site-api
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Forza
- **Description**: Show random image of car from Forza
- **Documentation**: https://docs.forza-api.tk
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### FreeToGame
- **Description**: Free-To-Play Games Database
- **Documentation**: https://www.freetogame.com/api-doc
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Fun Facts
- **Description**: Random Fun Facts
- **Documentation**: https://asli-fun-fact-api.herokuapp.com/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### FunTranslations
- **Description**: Translate Text into funny languages
- **Documentation**: https://api.funtranslations.com/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### GamerPower
- **Description**: Game Giveaways Tracker
- **Documentation**: https://www.gamerpower.com/api-read
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### GDBrowser
- **Description**: Easy way to use the Geometry Dash Servers
- **Documentation**: https://gdbrowser.com/api
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Geek-Jokes
- **Description**: Fetch a random geeky/programming related joke for use in all sorts of applications
- **Documentation**: https://github.com/sameerkumar18/geek-joke-api
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Genshin Impact
- **Description**: Genshin Impact game data
- **Documentation**: https://genshin.dev
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Giant Bomb
- **Description**: Video Games
- **Documentation**: https://www.giantbomb.com/api/documentation
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### GraphQL Pokemon
- **Description**: GraphQL powered Pokemon API. Supports generations 1 through 8
- **Documentation**: https://github.com/favware/graphql-pokemon
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Guild Wars 2
- **Description**: Guild Wars 2 Game Information
- **Documentation**: https://wiki.guildwars2.com/wiki/API:Main
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### GW2Spidy
- **Description**: GW2Spidy API, Items data on the Guild Wars 2 Trade Market
- **Documentation**: https://github.com/rubensayshi/gw2spidy/wiki
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Halo
- **Description**: Halo 5 and Halo Wars 2 Information
- **Documentation**: https://developer.haloapi.com/
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Hearthstone
- **Description**: Hearthstone Cards Information
- **Documentation**: http://hearthstoneapi.com/
- **Category**: Games & Comics
- **Auth Type**: X-Mashape-Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Humble Bundle
- **Description**: Humble Bundle's current bundles
- **Documentation**: https://rapidapi.com/Ziggoto/api/humble-bundle
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Humor
- **Description**: Humor, Jokes, and Memes
- **Documentation**: https://humorapi.com
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Hypixel
- **Description**: Hypixel player stats
- **Documentation**: https://api.hypixel.net/
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Hyrule Compendium
- **Description**: Data on all interactive items from The Legend of Zelda: BOTW
- **Documentation**: https://github.com/gadhagod/Hyrule-Compendium-API
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Hytale
- **Description**: Hytale blog posts and jobs
- **Documentation**: https://hytale-api.com/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### IGDB.com
- **Description**: Video Game Database
- **Documentation**: https://api-docs.igdb.com
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### JokeAPI
- **Description**: Programming, Miscellaneous and Dark Jokes
- **Documentation**: https://sv443.net/jokeapi/v2/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Jokes One
- **Description**: Joke of the day and large category of jokes accessible via REST API
- **Documentation**: https://jokes.one/api/joke/
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Jservice
- **Description**: Jeopardy Question Database
- **Documentation**: http://jservice.io
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Lichess
- **Description**: Access to all data of users, games, puzzles and etc on Lichess
- **Documentation**: https://lichess.org/api
- **Category**: Games & Comics
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Magic The Gathering
- **Description**: Magic The Gathering Game Information
- **Documentation**: http://magicthegathering.io/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Mario Kart Tour
- **Description**: API for Drivers, Karts, Gliders and Courses
- **Documentation**: https://mario-kart-tour-api.herokuapp.com/
- **Category**: Games & Comics
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Marvel
- **Description**: Marvel Comics
- **Documentation**: https://developer.marvel.com
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Minecraft Server Status
- **Description**: API to get Information about a Minecraft Server
- **Documentation**: https://api.mcsrvstat.us
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### MMO Games
- **Description**: MMO Games Database, News and Giveaways
- **Documentation**: https://www.mmobomb.com/api
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### mod.io
- **Description**: Cross Platform Mod API
- **Documentation**: https://docs.mod.io
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Mojang
- **Description**: Mojang / Minecraft API
- **Documentation**: https://wiki.vg/Mojang_API
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Monster Hunter World
- **Description**: Monster Hunter World data
- **Documentation**: https://docs.mhw-db.com/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Open Trivia
- **Description**: Trivia Questions
- **Documentation**: https://opentdb.com/api_config.php
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### PandaScore
- **Description**: E-sports games and results
- **Documentation**: https://developers.pandascore.co/
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Path of Exile
- **Description**: Path of Exile Game Information
- **Documentation**: https://www.pathofexile.com/developer/docs
- **Category**: Games & Comics
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### PlayerDB
- **Description**: Query Minecraft, Steam and XBox Accounts
- **Documentation**: https://playerdb.co/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Pokéapi
- **Description**: Pokémon Information
- **Documentation**: https://pokeapi.co
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### PokéAPI (GraphQL)
- **Description**: The Unofficial GraphQL for PokeAPI
- **Documentation**: https://github.com/mazipan/graphql-pokeapi
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Pokémon TCG
- **Description**: Pokémon TCG Information
- **Documentation**: https://pokemontcg.io
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Psychonauts
- **Description**: Psychonauts World Characters Information and PSI Powers
- **Documentation**: https://psychonauts-api.netlify.app/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### PUBG
- **Description**: Access in-game PUBG data
- **Documentation**: https://developer.pubg.com/
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Puyo Nexus
- **Description**: Puyo Puyo information from Puyo Nexus Wiki
- **Documentation**: https://github.com/deltadex7/puyodb-api-deno
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### quizapi.io
- **Description**: Access to various kind of quiz questions
- **Documentation**: https://quizapi.io/
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Raider
- **Description**: Provides detailed character and guild rankings for Raiding and Mythic+ content in World of Warcraft
- **Documentation**: https://raider.io/api
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### RAWG.io
- **Description**: 500,000+ games for 50 platforms including mobiles
- **Documentation**: https://rawg.io/apidocs
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Rick and Morty
- **Description**: All the Rick and Morty information, including images
- **Documentation**: https://rickandmortyapi.com
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Riot Games
- **Description**: League of Legends Game Information
- **Documentation**: https://developer.riotgames.com/
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### RPS 101
- **Description**: Rock, Paper, Scissors with 101 objects
- **Documentation**: https://rps101.pythonanywhere.com/api
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### RuneScape
- **Description**: RuneScape and OSRS RPGs information
- **Documentation**: https://runescape.wiki/w/Application_programming_interface
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Sakura CardCaptor
- **Description**: Sakura CardCaptor Cards Information
- **Documentation**: https://github.com/JessVel/sakura-card-captor-api
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Scryfall
- **Description**: Magic: The Gathering database
- **Documentation**: https://scryfall.com/docs/api
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### SpaceTradersAPI
- **Description**: A playable inter-galactic space trading MMOAPI
- **Documentation**: https://spacetraders.io?rel=pub-apis
- **Category**: Games & Comics
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Steam
- **Description**: Steam Web API documentation
- **Documentation**: https://steamapi.xpaw.me/
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Steam
- **Description**: Internal Steam Web API documentation
- **Documentation**: https://github.com/Revadike/InternalSteamWebAPI/wiki
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### SuperHeroes
- **Description**: All SuperHeroes and Villains data from all universes under a single API
- **Documentation**: https://superheroapi.com
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### TCGdex
- **Description**: Multi languages Pokémon TCG Information
- **Documentation**: https://www.tcgdex.net/docs
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Tebex
- **Description**: Tebex API for information about game purchases
- **Documentation**: https://docs.tebex.io/plugin/
- **Category**: Games & Comics
- **Auth Type**: X-Mashape-Key
- **HTTPS**: Yes
- **CORS**: No

### TETR.IO
- **Description**: TETR.IO Tetra Channel API
- **Documentation**: https://tetr.io/about/api/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Tronald Dump
- **Description**: The dumbest things Donald Trump has ever said
- **Documentation**: https://www.tronalddump.io/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Universalis
- **Description**: Final Fantasy XIV market board data
- **Documentation**: https://universalis.app/docs/index.html
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Valorant (non-official)
- **Description**: An extensive API containing data of most Valorant in-game items, assets and more
- **Documentation**: https://valorant-api.com
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Warface (non-official)
- **Description**: Official API proxy with better data structure and more features
- **Documentation**: https://api.wfstats.cf
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Wargaming.net
- **Description**: Wargaming.net info and stats
- **Documentation**: https://developers.wargaming.net/
- **Category**: Games & Comics
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### When is next MCU film
- **Description**: Upcoming MCU film information
- **Documentation**: https://github.com/DiljotSG/MCU-Countdown/blob/develop/docs/API.md
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### xkcd
- **Description**: Retrieve xkcd comics as JSON
- **Documentation**: https://xkcd.com/json.html
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Yu-Gi-Oh!
- **Description**: Yu-Gi-Oh! TCG Information
- **Documentation**: https://db.ygoprodeck.com/api-guide/
- **Category**: Games & Comics
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Geocoding

### IP Geolocation
- **Description**: Geolocate website visitors from their IPs
- **Documentation**: https://www.abstractapi.com/ip-geolocation-api
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Actinia Grass GIS
- **Description**: Actinia is an open source REST API for geographical data that uses GRASS GIS
- **Documentation**: https://actinia.mundialis.de/api_docs/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### administrative-divisons-db
- **Description**: Get all administrative divisions of a country
- **Documentation**: https://github.com/kamikazechaser/administrative-divisions-db
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### adresse.data.gouv.fr
- **Description**: Address database of France, geocoding and reverse
- **Documentation**: https://adresse.data.gouv.fr
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Airtel IP
- **Description**: IP Geolocation API. Collecting data from multiple sources
- **Documentation**: https://sys.airtel.lv/ip2country/1.1.1.1/?full=true
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Apiip
- **Description**: Get location information by IP address
- **Documentation**: https://apiip.net/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### apilayer ipstack
- **Description**: Locate and identify website visitors by IP address
- **Documentation**: https://ipstack.com/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Battuta
- **Description**: A (country/region/city) in-cascade location API
- **Documentation**: http://battuta.medunes.net
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### BigDataCloud
- **Description**: Provides fast and accurate IP geolocation APIs along with security checks and confidence area
- **Documentation**: https://www.bigdatacloud.com/ip-geolocation-apis
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Bing Maps
- **Description**: Create/customize digital maps based on Bing Maps data
- **Documentation**: https://www.microsoft.com/maps/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### bng2latlong
- **Description**: Convert British OSGB36 easting and northing (British National Grid) to WGS84 latitude and longitude
- **Documentation**: https://www.getthedata.com/bng2latlong
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Cartes.io
- **Description**: Create maps and markers for anything
- **Documentation**: https://github.com/M-Media-Group/Cartes.io/wiki/API
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Cep.la
- **Description**: Brazil RESTful API to find information about streets, zip codes, neighborhoods, cities and states
- **Documentation**: http://cep.la/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### CitySDK
- **Description**: Open APIs for select European cities
- **Documentation**: http://www.citysdk.eu/citysdk-toolkit/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Country
- **Description**: Get your visitor's country from their IP
- **Documentation**: http://country.is/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### CountryStateCity
- **Description**: World countries, states, regions, provinces, cities & towns in JSON, SQL, XML, YAML, & CSV format
- **Documentation**: https://countrystatecity.in/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Ducks Unlimited
- **Description**: API explorer that gives a query URL with a JSON response of locations and cities
- **Documentation**: https://gis.ducks.org/datasets/du-university-chapters/api
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### GeoApi
- **Description**: French geographical data
- **Documentation**: https://api.gouv.fr/api/geoapi.html
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Geoapify
- **Description**: Forward and reverse geocoding, address autocomplete
- **Documentation**: https://www.geoapify.com/api/geocoding-api/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Geocod.io
- **Description**: Address geocoding / reverse geocoding in bulk
- **Documentation**: https://www.geocod.io/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Geocode.xyz
- **Description**: Provides worldwide forward/reverse geocoding, batch geocoding and geoparsing
- **Documentation**: https://geocode.xyz/api
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Geocodify.com
- **Description**: Worldwide geocoding, geoparsing and autocomplete for addresses
- **Documentation**: https://geocodify.com/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Geodata.gov.gr
- **Description**: Open geospatial data and API service for Greece
- **Documentation**: https://geodata.gov.gr/en/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### GeoDataSource
- **Description**: Geocoding of city name by using latitude and longitude coordinates
- **Documentation**: https://www.geodatasource.com/web-service
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### GeoDB Cities
- **Description**: Get global city, region, and country data
- **Documentation**: http://geodb-cities-api.wirefreethought.com/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### GeographQL
- **Description**: A Country, State, and City GraphQL API
- **Documentation**: https://geographql.netlify.app
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### GeoJS
- **Description**: IP geolocation with ChatOps integration
- **Documentation**: https://www.geojs.io/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Geokeo
- **Description**: Geokeo geocoding service- with 2500 free api requests daily
- **Documentation**: https://geokeo.com
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### GeoNames
- **Description**: Place names and other geographical data
- **Documentation**: http://www.geonames.org/export/web-services.html
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### geoPlugin
- **Description**: IP geolocation and currency conversion
- **Documentation**: https://www.geoplugin.com
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Google Earth Engine
- **Description**: A cloud-based platform for planetary-scale environmental data analysis
- **Documentation**: https://developers.google.com/earth-engine/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Google Maps
- **Description**: Create/customize digital maps based on Google Maps data
- **Documentation**: https://developers.google.com/maps/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Graph Countries
- **Description**: Country-related data like currencies, languages, flags, regions+subregions and bordering countries
- **Documentation**: https://github.com/lennertVanSever/graphcountries
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### HelloSalut
- **Description**: Get hello translation following user language
- **Documentation**: https://fourtonfish.com/project/hellosalut-api/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### HERE Maps
- **Description**: Create/customize digital maps based on HERE Maps data
- **Documentation**: https://developer.here.com
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Hirak IP to Country
- **Description**: Ip to location with country code, currency code & currency name, fast response, unlimited requests
- **Documentation**: https://iplocation.hirak.site/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Hong Kong GeoData Store
- **Description**: API for accessing geo-data of Hong Kong
- **Documentation**: https://geodata.gov.hk/gs/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### IBGE
- **Description**: Aggregate services of IBGE (Brazilian Institute of Geography and Statistics)
- **Documentation**: https://servicodados.ibge.gov.br/api/docs/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### IP 2 Country
- **Description**: Map an IP to a country
- **Documentation**: https://ip2country.info
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### IP Address Details
- **Description**: Find geolocation with ip address
- **Documentation**: https://ipinfo.io/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### IP Vigilante
- **Description**: Free IP Geolocation API
- **Documentation**: https://www.ipvigilante.com/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### ip-api
- **Description**: Find location with IP address or domain
- **Documentation**: https://ip-api.com/docs
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### IP2Location
- **Description**: IP geolocation web service to get more than 55 parameters
- **Documentation**: https://www.ip2location.com/web-service/ip2location
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### IP2Proxy
- **Description**: Detect proxy and VPN using IP address
- **Documentation**: https://www.ip2location.com/web-service/ip2proxy
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ipapi.co
- **Description**: Find IP address location information
- **Documentation**: https://ipapi.co/api/#introduction
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### ipapi.com
- **Description**: Real-time Geolocation & Reverse IP Lookup REST API
- **Documentation**: https://ipapi.com/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### IPGEO
- **Description**: Unlimited free IP Address API with useful information
- **Documentation**: https://api.techniknews.net/ipgeo/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### ipgeolocation
- **Description**: IP Geolocation AP with free plan 30k requests per month
- **Documentation**: https://ipgeolocation.io/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### IPInfoDB
- **Description**: Free Geolocation tools and APIs for country, region, city and time zone lookup by IP address
- **Documentation**: https://www.ipinfodb.com/api
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ipstack
- **Description**: Locate and identify website visitors by IP address
- **Documentation**: https://ipstack.com/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Kakao Maps
- **Description**: Kakao Maps provide multiple APIs for Korean maps
- **Documentation**: https://apis.map.kakao.com
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### keycdn IP Location Finder
- **Description**: Get the IP geolocation data through the simple REST API. All the responses are JSON encoded
- **Documentation**: https://tools.keycdn.com/geo
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### LocationIQ
- **Description**: Provides forward/reverse geocoding and batch geocoding
- **Documentation**: https://locationiq.org/docs/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Longdo Map
- **Description**: Interactive map with detailed places and information portal in Thailand
- **Documentation**: https://map.longdo.com/docs/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Mapbox
- **Description**: Create/customize beautiful digital maps
- **Documentation**: https://docs.mapbox.com/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### MapQuest
- **Description**: To access tools and resources to map the world
- **Documentation**: https://developer.mapquest.com/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Mexico
- **Description**: Mexico RESTful zip codes API
- **Documentation**: https://github.com/IcaliaLabs/sepomex
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Nominatim
- **Description**: Provides worldwide forward / reverse geocoding
- **Documentation**: https://nominatim.org/release-docs/latest/api/Overview/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### One Map, Singapore
- **Description**: Singapore Land Authority REST API services for Singapore addresses
- **Documentation**: https://www.onemap.gov.sg/docs/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OnWater
- **Description**: Determine if a lat/lon is on water or land
- **Documentation**: https://onwater.io/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Topo Data
- **Description**: Elevation and ocean depth for a latitude and longitude
- **Documentation**: https://www.opentopodata.org
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### OpenCage
- **Description**: Forward and reverse geocoding using open data
- **Documentation**: https://opencagedata.com
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### openrouteservice.org
- **Description**: Directions, POIs, isochrones, geocoding (+reverse), elevation, and more
- **Documentation**: https://openrouteservice.org/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OpenStreetMap
- **Description**: Navigation, geolocation and geographical data
- **Documentation**: http://wiki.openstreetmap.org/wiki/API
- **Category**: Geocoding
- **Auth Type**: OAuth2
- **HTTPS**: No
- **CORS**: Unknown

### Pinball Map
- **Description**: A crowdsourced map of public pinball machines
- **Documentation**: https://pinballmap.com/api/v1/docs
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### positionstack
- **Description**: Forward & Reverse Batch Geocoding REST API
- **Documentation**: https://positionstack.com/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Postali
- **Description**: Mexico Zip Codes API
- **Documentation**: https://postali.app/api
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### PostcodeData.nl
- **Description**: Provide geolocation data based on postcode for Dutch addresses
- **Documentation**: http://api.postcodedata.nl/v1/postcode/?postcode=1211EP&streetnumber=60&ref=domeinnaam.nl&type=json
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Postcodes.io
- **Description**: Postcode lookup & Geolocation for the UK
- **Documentation**: https://postcodes.io
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Queimadas INPE
- **Description**: Access to heat focus data (probable wildfire)
- **Documentation**: https://queimadas.dgi.inpe.br/queimadas/dados-abertos/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### REST Countries
- **Description**: Get information about countries via a RESTful API
- **Documentation**: https://restcountries.com
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### RoadGoat Cities
- **Description**: Cities content & photos API
- **Documentation**: https://www.roadgoat.com/business/cities-api
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Rwanda Locations
- **Description**: Rwanda Provences, Districts, Cities, Capital City, Sector, cells, villages and streets
- **Documentation**: https://rapidapi.com/victorkarangwa4/api/rwanda
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### SLF
- **Description**: German city, country, river, database
- **Documentation**: https://github.com/slftool/slftool.github.io/blob/master/API.md
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### SpotSense
- **Description**: Add location based interactions to your mobile app
- **Documentation**: https://spotsense.io/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Telize
- **Description**: Telize offers location information from any IP address
- **Documentation**: https://rapidapi.com/fcambus/api/telize/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### TomTom
- **Description**: Maps, Directions, Places and Traffic APIs
- **Documentation**: https://developer.tomtom.com/
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Uebermaps
- **Description**: Discover and share maps with friends
- **Documentation**: https://uebermaps.com/api/v2
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### US ZipCode
- **Description**: Validate and append data for any US ZipCode
- **Documentation**: https://www.smarty.com/docs/cloud/us-zipcode-api
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Utah AGRC
- **Description**: Utah Web API for geocoding Utah addresses
- **Documentation**: https://api.mapserv.utah.gov
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ViaCep
- **Description**: Brazil RESTful zip codes API
- **Documentation**: https://viacep.com.br
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### What3Words
- **Description**: Three words as rememberable and unique coordinates worldwide
- **Documentation**: https://what3words.com
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Yandex.Maps Geocoder
- **Description**: Use geocoding to get an object's coordinates from its address
- **Documentation**: https://yandex.com/dev/maps/geocoder
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ZipCodeAPI
- **Description**: US zip code distance, radius and location API
- **Documentation**: https://www.zipcodeapi.com
- **Category**: Geocoding
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Zippopotam.us
- **Description**: Get information about place such as country, city, state, etc
- **Documentation**: http://www.zippopotam.us
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Ziptastic
- **Description**: Get the country, state, and city of any US zip-code
- **Documentation**: https://ziptasticapi.com/
- **Category**: Geocoding
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Government

### Bank Negara Malaysia Open Data
- **Description**: Malaysia Central Bank Open Data
- **Documentation**: https://apikijangportal.bnm.gov.my/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### BCLaws
- **Description**: Access to the laws of British Columbia
- **Documentation**: https://www.bclaws.gov.bc.ca/civix/template/complete/api/index.html
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Brazil
- **Description**: Community driven API for Brazil Public Data
- **Documentation**: https://brasilapi.com.br/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Brazil Central Bank Open Data
- **Description**: Brazil Central Bank Open Data
- **Documentation**: https://dadosabertos.bcb.gov.br/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Brazil Receita WS
- **Description**: Consult companies by CNPJ for Brazilian companies
- **Documentation**: https://www.receitaws.com.br/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Brazilian Chamber of Deputies Open Data
- **Description**: Provides legislative information in Apis XML and JSON, as well as files in various formats
- **Documentation**: https://dadosabertos.camara.leg.br/swagger/api.html
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Census.gov
- **Description**: The US Census Bureau provides various APIs and data sets on demographics and businesses
- **Documentation**: https://www.census.gov/data/developers/data-sets.html
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### City, Berlin
- **Description**: Berlin(DE) City Open Data
- **Documentation**: https://daten.berlin.de/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### City, Gdańsk
- **Description**: Gdańsk (PL) City Open Data
- **Documentation**: https://ckan.multimediagdansk.pl/en
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### City, Gdynia
- **Description**: Gdynia (PL) City Open Data
- **Documentation**: http://otwartedane.gdynia.pl/en/api_doc.html
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### City, Helsinki
- **Description**: Helsinki(FI) City Open Data
- **Documentation**: https://hri.fi/en_gb/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### City, Lviv
- **Description**: Lviv(UA) City Open Data
- **Documentation**: https://opendata.city-adm.lviv.ua/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### City, Nantes Open Data
- **Description**: Nantes(FR) City Open Data
- **Documentation**: https://data.nantesmetropole.fr/pages/home/
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### City, New York Open Data
- **Description**: New York (US) City Open Data
- **Documentation**: https://opendata.cityofnewyork.us/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### City, Prague Open Data
- **Description**: Prague(CZ) City Open Data
- **Documentation**: http://opendata.praha.eu/en
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### City, Toronto Open Data
- **Description**: Toronto (CA) City Open Data
- **Documentation**: https://open.toronto.ca/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Code.gov
- **Description**: The primary platform for Open Source and code sharing for the U.S. Federal Government
- **Documentation**: https://code.gov
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Colorado Information Marketplace
- **Description**: Colorado State Government Open Data
- **Documentation**: https://data.colorado.gov/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Data USA
- **Description**: US Public Data
- **Documentation**: https://datausa.io/about/api/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Data.gov
- **Description**: US Government Data
- **Documentation**: https://api.data.gov/
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Data.parliament.uk
- **Description**: Contains live datasets including information about petitions, bills, MP votes, attendance and more
- **Documentation**: https://explore.data.parliament.uk/?learnmore=Members
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Deutscher Bundestag DIP
- **Description**: This API provides read access to DIP entities (e.g. activities, persons, printed material)
- **Documentation**: https://dip.bundestag.de/documents/informationsblatt_zur_dip_api_v01.pdf
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### District of Columbia Open Data
- **Description**: Contains D.C. government public datasets, including crime, GIS, financial data, and so on
- **Documentation**: http://opendata.dc.gov/pages/using-apis
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### EPA
- **Description**: Web services and data sets from the US Environmental Protection Agency
- **Documentation**: https://www.epa.gov/developers/data-data-products#apis
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### FBI Wanted
- **Description**: Access information on the FBI Wanted program
- **Documentation**: https://www.fbi.gov/wanted/api
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### FEC
- **Description**: Information on campaign donations in federal elections
- **Documentation**: https://api.open.fec.gov/developers/
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Federal Register
- **Description**: The Daily Journal of the United States Government
- **Documentation**: https://www.federalregister.gov/reader-aids/developer-resources/rest-api
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Food Standards Agency
- **Description**: UK food hygiene rating data API
- **Documentation**: http://ratings.food.gov.uk/open-data/en-GB
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Gazette Data, UK
- **Description**: UK official public record API
- **Documentation**: https://www.thegazette.co.uk/data
- **Category**: Government
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Gun Policy
- **Description**: International firearm injury prevention and policy
- **Documentation**: https://www.gunpolicy.org/api
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### INEI
- **Description**: Peruvian Statistical Government Open Data
- **Documentation**: http://iinei.inei.gob.pe/microdatos/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Interpol Red Notices
- **Description**: Access and search Interpol Red Notices
- **Documentation**: https://interpol.api.bund.dev/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Istanbul (İBB) Open Data
- **Description**: Data sets from the İstanbul Metropolitan Municipality (İBB)
- **Documentation**: https://data.ibb.gov.tr
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### National Park Service, US
- **Description**: Data from the US National Park Service
- **Documentation**: https://www.nps.gov/subjects/developer/
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Open Government, ACT
- **Description**: Australian Capital Territory Open Data
- **Documentation**: https://www.data.act.gov.au/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Argentina
- **Description**: Argentina Government Open Data
- **Documentation**: https://datos.gob.ar/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Australia
- **Description**: Australian Government Open Data
- **Documentation**: https://www.data.gov.au/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Austria
- **Description**: Austria Government Open Data
- **Documentation**: https://www.data.gv.at/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Belgium
- **Description**: Belgium Government Open Data
- **Documentation**: https://data.gov.be/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Canada
- **Description**: Canadian Government Open Data
- **Documentation**: http://open.canada.ca/en
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Open Government, Colombia
- **Description**: Colombia Government Open Data
- **Documentation**: https://www.dane.gov.co/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Open Government, Cyprus
- **Description**: Cyprus Government Open Data
- **Documentation**: https://data.gov.cy/?language=en
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Czech Republic
- **Description**: Czech Republic Government Open Data
- **Documentation**: https://data.gov.cz/english/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Denmark
- **Description**: Denmark Government Open Data
- **Documentation**: https://www.opendata.dk/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Estonia
- **Description**: Estonia Government Open Data
- **Documentation**: https://avaandmed.eesti.ee/instructions/opendata-dataset-api
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Finland
- **Description**: Finland Government Open Data
- **Documentation**: https://www.avoindata.fi/en
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, France
- **Description**: French Government Open Data
- **Documentation**: https://www.data.gouv.fr/
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Germany
- **Description**: Germany Government Open Data
- **Documentation**: https://www.govdata.de/daten/-/details/govdata-metadatenkatalog
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Greece
- **Description**: Greece Government Open Data
- **Documentation**: https://data.gov.gr/
- **Category**: Government
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, India
- **Description**: Indian Government Open Data
- **Documentation**: https://data.gov.in/
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Ireland
- **Description**: Ireland Government Open Data
- **Documentation**: https://data.gov.ie/pages/developers
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Italy
- **Description**: Italy Government Open Data
- **Documentation**: https://www.dati.gov.it/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Korea
- **Description**: Korea Government Open Data
- **Documentation**: https://www.data.go.kr/
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Lithuania
- **Description**: Lithuania Government Open Data
- **Documentation**: https://data.gov.lt/public/api/1
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Luxembourg
- **Description**: Luxembourgish Government Open Data
- **Documentation**: https://data.public.lu
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Mexico
- **Description**: Mexican Statistical Government Open Data
- **Documentation**: https://www.inegi.org.mx/datos/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Mexico
- **Description**: Mexico Government Open Data
- **Documentation**: https://datos.gob.mx/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Netherlands
- **Description**: Netherlands Government Open Data
- **Documentation**: https://data.overheid.nl/en/ondersteuning/data-publiceren/api
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, New South Wales
- **Description**: New South Wales Government Open Data
- **Documentation**: https://api.nsw.gov.au/
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, New Zealand
- **Description**: New Zealand Government Open Data
- **Documentation**: https://www.data.govt.nz/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Norway
- **Description**: Norwegian Government Open Data
- **Documentation**: https://data.norge.no/dataservices
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Open Government, Peru
- **Description**: Peru Government Open Data
- **Documentation**: https://www.datosabiertos.gob.pe/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Poland
- **Description**: Poland Government Open Data
- **Documentation**: https://dane.gov.pl/en
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Open Government, Portugal
- **Description**: Portugal Government Open Data
- **Documentation**: https://dados.gov.pt/en/docapi/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Open Government, Queensland Government
- **Description**: Queensland Government Open Data
- **Documentation**: https://www.data.qld.gov.au/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Romania
- **Description**: Romania Government Open Data
- **Documentation**: http://data.gov.ro/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Open Government, Saudi Arabia
- **Description**: Saudi Arabia Government Open Data
- **Documentation**: https://data.gov.sa
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Singapore
- **Description**: Singapore Government Open Data
- **Documentation**: https://data.gov.sg/developer
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Slovakia
- **Description**: Slovakia Government Open Data
- **Documentation**: https://data.gov.sk/en/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Slovenia
- **Description**: Slovenia Government Open Data
- **Documentation**: https://podatki.gov.si/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Open Government, South Australian Government
- **Description**: South Australian Government Open Data
- **Documentation**: https://data.sa.gov.au/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Spain
- **Description**: Spain Government Open Data
- **Documentation**: https://datos.gob.es/en
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Sweden
- **Description**: Sweden Government Open Data
- **Documentation**: https://www.dataportal.se/en/dataservice/91_29789/api-for-the-statistical-database
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Switzerland
- **Description**: Switzerland Government Open Data
- **Documentation**: https://handbook.opendata.swiss/de/content/nutzen/api-nutzen.html
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Taiwan
- **Description**: Taiwan Government Open Data
- **Documentation**: https://data.gov.tw/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Thailand
- **Description**: Thailand Government Open Data
- **Documentation**: https://data.go.th/
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, UK
- **Description**: UK Government Open Data
- **Documentation**: https://data.gov.uk/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, USA
- **Description**: United States Government Open Data
- **Documentation**: https://www.data.gov/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, Victoria State Government
- **Description**: Victoria State Government Open Data
- **Documentation**: https://www.data.vic.gov.au/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Government, West Australia
- **Description**: West Australia Open Data
- **Documentation**: https://data.wa.gov.au/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### PRC Exam Schedule
- **Description**: Unofficial Philippine Professional Regulation Commission's examination schedule
- **Documentation**: https://api.whenisthenextboardexam.com/docs/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Represent by Open North
- **Description**: Find Canadian Government Representatives
- **Documentation**: https://represent.opennorth.ca/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### UK Companies House
- **Description**: UK Companies House Data from the UK government
- **Documentation**: https://developer.company-information.service.gov.uk/
- **Category**: Government
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### US Presidential Election Data by TogaTech
- **Description**: Basic candidate data and live electoral vote counts for top two parties in US presidential election
- **Documentation**: https://uselection.togatech.org/api/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### USA.gov
- **Description**: Authoritative information on U.S. programs, events, services and more
- **Documentation**: https://www.usa.gov/developer
- **Category**: Government
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### USAspending.gov
- **Description**: US federal spending data
- **Documentation**: https://api.usaspending.gov/
- **Category**: Government
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Health

### CMS.gov
- **Description**: Access to the data from the CMS - medicare.gov
- **Documentation**: https://data.cms.gov/provider-data/
- **Category**: Health
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Coronavirus
- **Description**: HTTP API for Latest Covid-19 Data
- **Documentation**: https://pipedream.com/@pravin/http-api-for-latest-wuhan-coronavirus-data-2019-ncov-p_G6CLVM/readme
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Coronavirus in the UK
- **Description**: UK Government coronavirus data, including deaths and cases by region
- **Documentation**: https://coronavirus.data.gov.uk/details/developers-guide
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Covid Tracking Project
- **Description**: Covid-19  data for the US
- **Documentation**: https://covidtracking.com/data/api/version-2
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Covid-19
- **Description**: Covid 19 spread, infection and recovery
- **Documentation**: https://covid19api.com/
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Covid-19
- **Description**: Covid 19 cases, deaths and recovery per country
- **Documentation**: https://github.com/M-Media-Group/Covid-19-API
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Covid-19 Datenhub
- **Description**: Maps, datasets, applications and more in the context of COVID-19
- **Documentation**: https://npgeo-corona-npgeo-de.hub.arcgis.com
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Covid-19 Government Response
- **Description**: Government measures tracker to fight against the Covid-19 pandemic
- **Documentation**: https://covidtracker.bsg.ox.ac.uk
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Covid-19 India
- **Description**: Covid 19 statistics state and district wise about cases, vaccinations, recovery within India
- **Documentation**: https://data.covid19india.org/
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Covid-19 JHU CSSE
- **Description**: Open-source API for exploring Covid19 cases based on JHU CSSE
- **Documentation**: https://nuttaphat.com/covid19-api/
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Covid-19 Live Data
- **Description**: Global and countrywise data of Covid 19 daily Summary, confirmed cases, recovered and deaths
- **Documentation**: https://github.com/mathdroid/covid-19-api
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Covid-19 Philippines
- **Description**: Unofficial Covid-19 Web API for Philippines from data collected by DOH
- **Documentation**: https://github.com/Simperfy/Covid-19-API-Philippines-DOH
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### COVID-19 Tracker Canada
- **Description**: Details on Covid-19 cases across Canada
- **Documentation**: https://api.covid19tracker.ca/docs/1.0/overview
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### COVID-19 Tracker Sri Lanka
- **Description**: Provides situation of the COVID-19 patients reported in Sri Lanka
- **Documentation**: https://www.hpb.health.gov.lk/en/api-documentation
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### COVID-ID
- **Description**: Indonesian government Covid data per province
- **Documentation**: https://data.covid19.go.id/public/api/prov.json
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Dataflow Kit COVID-19
- **Description**: COVID-19 live statistics into sites per hour
- **Documentation**: https://covid-19.dataflowkit.com
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### FoodData Central
- **Description**: National Nutrient Database for Standard Reference
- **Documentation**: https://fdc.nal.usda.gov/
- **Category**: Health
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Healthcare.gov
- **Description**: Educational content about the US Health Insurance Marketplace
- **Documentation**: https://www.healthcare.gov/developers/
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Humanitarian Data Exchange
- **Description**: Humanitarian Data Exchange (HDX) is open platform for sharing data across crises and organisations
- **Documentation**: https://data.humdata.org/
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Infermedica
- **Description**: NLP based symptom checker and patient triage API for health diagnosis from text
- **Documentation**: https://developer.infermedica.com/docs/
- **Category**: Health
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### LAPIS
- **Description**: SARS-CoV-2 genomic sequences from public sources
- **Documentation**: https://cov-spectrum.ethz.ch/public
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Lexigram
- **Description**: NLP that extracts mentions of clinical concepts from text, gives access to clinical ontology
- **Documentation**: https://docs.lexigram.io/
- **Category**: Health
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Makeup
- **Description**: Makeup Information
- **Documentation**: http://makeup-api.herokuapp.com/
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### MyVaccination
- **Description**: Vaccination data for Malaysia
- **Documentation**: https://documenter.getpostman.com/view/16605343/Tzm8GG7u
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### NPPES
- **Description**: National Plan & Provider Enumeration System, info on healthcare providers registered in US
- **Documentation**: https://npiregistry.cms.hhs.gov/registry/help-api
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Nutritionix
- **Description**: Worlds largest verified nutrition database
- **Documentation**: https://developer.nutritionix.com/
- **Category**: Health
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Data NHS Scotland
- **Description**: Medical reference data and statistics by Public Health Scotland
- **Documentation**: https://www.opendata.nhs.scot
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Disease
- **Description**: API for Current cases and more stuff about COVID-19 and Influenza
- **Documentation**: https://disease.sh/
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### openFDA
- **Description**: Public FDA data about drugs, devices and foods
- **Documentation**: https://open.fda.gov
- **Category**: Health
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Orion Health
- **Description**: Medical platform which allows the development of applications for different healthcare scenarios
- **Documentation**: https://developer.orionhealth.io/
- **Category**: Health
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Quarantine
- **Description**: Coronavirus API with free COVID-19 live updates
- **Documentation**: https://quarantine.country/coronavirus/api/
- **Category**: Health
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

---

## Jobs

### Adzuna
- **Description**: Job board aggregator
- **Documentation**: https://developer.adzuna.com/overview
- **Category**: Jobs
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Arbeitnow
- **Description**: API for Job board aggregator in Europe / Remote
- **Documentation**: https://documenter.getpostman.com/view/18545278/UVJbJdKh
- **Category**: Jobs
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Arbeitsamt
- **Description**: API for the "Arbeitsamt", which is a german Job board aggregator
- **Documentation**: https://jobsuche.api.bund.dev/
- **Category**: Jobs
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Careerjet
- **Description**: Job search engine
- **Documentation**: https://www.careerjet.com/partners/api/
- **Category**: Jobs
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### DevITjobs UK
- **Description**: Jobs with GraphQL
- **Documentation**: https://devitjobs.uk/job_feed.xml
- **Category**: Jobs
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Findwork
- **Description**: Job board
- **Documentation**: https://findwork.dev/developers/
- **Category**: Jobs
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### GraphQL Jobs
- **Description**: Jobs with GraphQL
- **Documentation**: https://graphql.jobs/docs/api/
- **Category**: Jobs
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Jobs2Careers
- **Description**: Job aggregator
- **Documentation**: http://api.jobs2careers.com/api/spec.pdf
- **Category**: Jobs
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Jooble
- **Description**: Job search engine
- **Documentation**: https://jooble.org/api/about
- **Category**: Jobs
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Juju
- **Description**: Job search engine
- **Documentation**: http://www.juju.com/publisher/spec/
- **Category**: Jobs
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Open Skills
- **Description**: Job titles, skills and related jobs data
- **Documentation**: https://github.com/workforce-data-initiative/skills-api/wiki/API-Overview
- **Category**: Jobs
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Reed
- **Description**: Job board aggregator
- **Documentation**: https://www.reed.co.uk/developers
- **Category**: Jobs
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### The Muse
- **Description**: Job board and company profiles
- **Documentation**: https://www.themuse.com/developers/api/v2
- **Category**: Jobs
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Upwork
- **Description**: Freelance job board and management system
- **Documentation**: https://developers.upwork.com/
- **Category**: Jobs
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### USAJOBS
- **Description**: US government job board
- **Documentation**: https://developer.usajobs.gov/
- **Category**: Jobs
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### WhatJobs
- **Description**: Job search engine
- **Documentation**: https://www.whatjobs.com/affiliates
- **Category**: Jobs
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ZipRecruiter
- **Description**: Job search app and website
- **Documentation**: https://www.ziprecruiter.com/publishers
- **Category**: Jobs
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Machine Learning

### AI For Thai
- **Description**: Free Various Thai AI API
- **Documentation**: https://aiforthai.in.th/index.php
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Clarifai
- **Description**: Computer Vision
- **Documentation**: https://docs.clarifai.com/api-guide/api-overview
- **Category**: Machine Learning
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Cloudmersive
- **Description**: Image captioning, face recognition, NSFW classification
- **Documentation**: https://www.cloudmersive.com/image-recognition-and-processing-api
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Deepcode
- **Description**: AI for code review
- **Documentation**: https://www.deepcode.ai
- **Category**: Machine Learning
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Dialogflow
- **Description**: Natural Language Processing
- **Documentation**: https://cloud.google.com/dialogflow/docs/
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### EXUDE-API
- **Description**: Used for the primary ways for filtering the stopping, stemming words from the text data
- **Documentation**: http://uttesh.com/exude-api/
- **Category**: Machine Learning
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Hirak FaceAPI
- **Description**: Face detection, face recognition with age estimation/gender estimation, accurate, no quota limits
- **Documentation**: https://faceapi.hirak.site/
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Imagga
- **Description**: Image Recognition Solutions like Tagging, Visual Search, NSFW moderation
- **Documentation**: https://imagga.com/
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Inferdo
- **Description**: Computer Vision services like Facial detection, Image labeling, NSFW classification
- **Documentation**: https://rapidapi.com/user/inferdo
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### IPS Online
- **Description**: Face and License Plate Anonymization
- **Documentation**: https://docs.identity.ps/docs
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Irisnet
- **Description**: Realtime content moderation API that blocks or blurs unwanted images in real-time
- **Documentation**: https://irisnet.de/api/
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Keen IO
- **Description**: Data Analytics
- **Documentation**: https://keen.io/
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Machinetutors
- **Description**: AI Solutions: Video/Image Classification & Tagging, NSFW, Icon/Image/Audio Search, NLP
- **Documentation**: https://www.machinetutors.com/portfolio/MT_api.html
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### MessengerX.io
- **Description**: A FREE API for developers to build and monetize personalized ML based chat apps
- **Documentation**: https://messengerx.rtfd.io
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### NLP Cloud
- **Description**: NLP API using spaCy and transformers for NER, sentiments, classification, summarization, and more
- **Documentation**: https://nlpcloud.io
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OpenVisionAPI
- **Description**: Open source computer vision API based on open source models
- **Documentation**: https://openvisionapi.com
- **Category**: Machine Learning
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Perspective
- **Description**: NLP API to return probability that if text is toxic, obscene, insulting or threatening
- **Documentation**: https://perspectiveapi.com
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Roboflow Universe
- **Description**: Pre-trained computer vision models
- **Documentation**: https://universe.roboflow.com
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### SkyBiometry
- **Description**: Face Detection, Face Recognition and Face Grouping
- **Documentation**: https://skybiometry.com/documentation/
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Time Door
- **Description**: A time series analysis API
- **Documentation**: https://timedoor.io
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Unplugg
- **Description**: Forecasting API for timeseries data
- **Documentation**: https://unplu.gg/test_api.html
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### WolframAlpha
- **Description**: Provides specific answers to questions using data and algorithms
- **Documentation**: https://products.wolframalpha.com/api/
- **Category**: Machine Learning
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Music

### 7digital
- **Description**: Api of Music store 7digital
- **Documentation**: https://docs.7digital.com/reference
- **Category**: Music
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### AI Mastering
- **Description**: Automated Music Mastering
- **Documentation**: https://aimastering.com/api_docs/
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Audiomack
- **Description**: Api of the streaming music hub Audiomack
- **Documentation**: https://www.audiomack.com/data-api/docs
- **Category**: Music
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Bandcamp
- **Description**: API of Music store Bandcamp
- **Documentation**: https://bandcamp.com/developer
- **Category**: Music
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Bandsintown
- **Description**: Music Events
- **Documentation**: https://app.swaggerhub.com/apis/Bandsintown/PublicAPI/3.0.0
- **Category**: Music
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Deezer
- **Description**: Music
- **Documentation**: https://developers.deezer.com/api
- **Category**: Music
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Discogs
- **Description**: Music
- **Documentation**: https://www.discogs.com/developers/
- **Category**: Music
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Freesound
- **Description**: Music Samples
- **Documentation**: https://freesound.org/docs/api/
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Gaana
- **Description**: API to retrieve song information from Gaana
- **Documentation**: https://github.com/cyberboysumanjay/GaanaAPI
- **Category**: Music
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Genius
- **Description**: Crowdsourced lyrics and music knowledge
- **Documentation**: https://docs.genius.com/
- **Category**: Music
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Genrenator
- **Description**: Music genre generator
- **Documentation**: https://binaryjazz.us/genrenator-api/
- **Category**: Music
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### iTunes Search
- **Description**: Software products
- **Documentation**: https://affiliate.itunes.apple.com/resources/documentation/itunes-store-web-service-search-api/
- **Category**: Music
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Jamendo
- **Description**: Music
- **Documentation**: https://developer.jamendo.com/v3.0/docs
- **Category**: Music
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### JioSaavn
- **Description**: API to retrieve song information, album meta data and many more from JioSaavn
- **Documentation**: https://github.com/cyberboysumanjay/JioSaavnAPI
- **Category**: Music
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### KKBOX
- **Description**: Get music libraries, playlists, charts, and perform out of KKBOX's platform
- **Documentation**: https://developer.kkbox.com
- **Category**: Music
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### KSoft.Si Lyrics
- **Description**: API to get lyrics for songs
- **Documentation**: https://docs.ksoft.si/api/lyrics-api
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### LastFm
- **Description**: Music
- **Documentation**: https://www.last.fm/api
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Lyrics.ovh
- **Description**: Simple API to retrieve the lyrics of a song
- **Documentation**: https://lyricsovh.docs.apiary.io
- **Category**: Music
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Mixcloud
- **Description**: Music
- **Documentation**: https://www.mixcloud.com/developers/
- **Category**: Music
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### MusicBrainz
- **Description**: Music
- **Documentation**: https://musicbrainz.org/doc/Development/XML_Web_Service/Version_2
- **Category**: Music
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Musixmatch
- **Description**: Music
- **Documentation**: https://developer.musixmatch.com/
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Napster
- **Description**: Music
- **Documentation**: https://developer.napster.com/api/v2.2
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Openwhyd
- **Description**: Download curated playlists of streaming tracks (YouTube, SoundCloud, etc...)
- **Documentation**: https://openwhyd.github.io/openwhyd/API
- **Category**: Music
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Phishin
- **Description**: A web-based archive of legal live audio recordings of the improvisational rock band Phish
- **Documentation**: https://phish.in/api-docs
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Radio Browser
- **Description**: List of internet radio stations
- **Documentation**: https://api.radio-browser.info/
- **Category**: Music
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Songkick
- **Description**: Music Events
- **Documentation**: https://www.songkick.com/developer/
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Songlink / Odesli
- **Description**: Get all the services on which a song is available
- **Documentation**: https://www.notion.so/API-d0ebe08a5e304a55928405eb682f6741
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Songsterr
- **Description**: Provides guitar, bass and drums tabs and chords
- **Documentation**: https://www.songsterr.com/a/wa/api/
- **Category**: Music
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### SoundCloud
- **Description**: With SoundCloud API you can build applications that will give more power to control your content
- **Documentation**: https://developers.soundcloud.com/docs/api/guide
- **Category**: Music
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Spotify
- **Description**: View Spotify music catalog, manage users' libraries, get recommendations and more
- **Documentation**: https://beta.developer.spotify.com/documentation/web-api/
- **Category**: Music
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### TasteDive
- **Description**: Similar artist API (also works for movies and TV shows)
- **Documentation**: https://tastedive.com/read/api
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### TheAudioDB
- **Description**: Music
- **Documentation**: https://www.theaudiodb.com/api_guide.php
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Vagalume
- **Description**: Crowdsourced lyrics and music knowledge
- **Documentation**: https://api.vagalume.com.br/docs/
- **Category**: Music
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## News

### apilayer mediastack
- **Description**: Free, Simple REST API for Live News & Blog Articles
- **Documentation**: https://mediastack.com/
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Associated Press
- **Description**: Search for news and metadata from Associated Press
- **Documentation**: https://developer.ap.org/
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Chronicling America
- **Description**: Provides access to millions of pages of historic US newspapers from the Library of Congress
- **Documentation**: http://chroniclingamerica.loc.gov/about/api/
- **Category**: News
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Currents
- **Description**: Latest news published in various news sources, blogs and forums
- **Documentation**: https://currentsapi.services/
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Feedbin
- **Description**: RSS reader
- **Documentation**: https://github.com/feedbin/feedbin-api
- **Category**: News
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### GNews
- **Description**: Search for news from various sources
- **Documentation**: https://gnews.io/
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Graphs for Coronavirus
- **Description**: Each Country separately and Worldwide Graphs for Coronavirus. Daily updates
- **Documentation**: https://corona.dnsforfamily.com/api.txt
- **Category**: News
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Inshorts News
- **Description**: Provides news from inshorts
- **Documentation**: https://github.com/cyberboysumanjay/Inshorts-News-API
- **Category**: News
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### MarketAux
- **Description**: Live stock market news with tagged tickers + sentiment and stats JSON API
- **Documentation**: https://www.marketaux.com/
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### New York Times
- **Description**: The New York Times Developer Network
- **Documentation**: https://developer.nytimes.com/
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### News
- **Description**: Headlines currently published on a range of news sources and blogs
- **Documentation**: https://newsapi.org/
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### NewsData
- **Description**: News data API for live-breaking news and headlines from reputed  news sources
- **Documentation**: https://newsdata.io/docs
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### NewsX
- **Description**: Get or Search Latest Breaking News with ML Powered Summaries 🤖
- **Documentation**: https://rapidapi.com/machaao-inc-machaao-inc-default/api/newsx/
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### NPR One
- **Description**: Personalized news listening experience from NPR
- **Documentation**: http://dev.npr.org/api/
- **Category**: News
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Spaceflight News
- **Description**: Spaceflight related news 🚀
- **Documentation**: https://spaceflightnewsapi.net
- **Category**: News
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### The Guardian
- **Description**: Access all the content the Guardian creates, categorised by tags and section
- **Documentation**: http://open-platform.theguardian.com/
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### The Old Reader
- **Description**: RSS reader
- **Documentation**: https://github.com/theoldreader/api
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### TheNews
- **Description**: Aggregated headlines, top story and live news JSON API
- **Documentation**: https://www.thenewsapi.com/
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Trove
- **Description**: Search through the National Library of Australia collection of 1000s of digitised newspapers
- **Documentation**: https://trove.nla.gov.au/about/create-something/using-api
- **Category**: News
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Open Data

### 18F
- **Description**: Unofficial US Federal Government API Development
- **Documentation**: http://18f.github.io/API-All-the-X/
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### API Setu
- **Description**: An Indian Government platform that provides a lot of APIS for KYC, business, education & employment
- **Documentation**: https://www.apisetu.gov.in/
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Archive.org
- **Description**: The Internet Archive
- **Documentation**: https://archive.readme.io/docs
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Black History Facts
- **Description**: Contribute or search one of the largest black history fact databases on the web
- **Documentation**: https://www.blackhistoryapi.io/docs
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### BotsArchive
- **Description**: JSON formatted details about Telegram Bots available in database
- **Documentation**: https://botsarchive.com/docs.html
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Callook.info
- **Description**: United States ham radio callsigns
- **Documentation**: https://callook.info
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### CARTO
- **Description**: Location Information Prediction
- **Documentation**: https://carto.com/
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### CollegeScoreCard.ed.gov
- **Description**: Data on higher education institutions in the United States
- **Documentation**: https://collegescorecard.ed.gov/data/
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Enigma Public
- **Description**: Broadest collection of public data
- **Documentation**: https://developers.enigma.com/docs
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### French Address Search
- **Description**: Address search via the French Government
- **Documentation**: https://geo.api.gouv.fr/adresse
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### GENESIS
- **Description**: Federal Statistical Office Germany
- **Documentation**: https://www.destatis.de/EN/Service/OpenData/api-webservice.html
- **Category**: Open Data
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Joshua Project
- **Description**: People groups of the world with the fewest followers of Christ
- **Documentation**: https://api.joshuaproject.net/
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Kaggle
- **Description**: Create and interact with Datasets, Notebooks, and connect with Kaggle
- **Documentation**: https://www.kaggle.com/docs/api
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### LinkPreview
- **Description**: Get JSON formatted summary with title, description and preview image for any requested URL
- **Documentation**: https://www.linkpreview.net
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Lowy Asia Power Index
- **Description**: Get measure resources and influence to rank the relative power of states in Asia
- **Documentation**: https://github.com/0x0is1/lowy-index-api-docs
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Microlink.io
- **Description**: Extract structured data from any website
- **Documentation**: https://microlink.io
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Nasdaq Data Link
- **Description**: Stock market data
- **Documentation**: https://docs.data.nasdaq.com/
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Nobel Prize
- **Description**: Open data about nobel prizes and events
- **Documentation**: https://www.nobelprize.org/about/developer-zone-2/
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Open Data Minneapolis
- **Description**: Spatial (GIS) and non-spatial city data for Minneapolis
- **Documentation**: https://opendata.minneapolismn.gov/
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### openAFRICA
- **Description**: Large datasets repository of African open data
- **Documentation**: https://africaopendata.org/
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### OpenCorporates
- **Description**: Data on corporate entities and directors in many countries
- **Documentation**: http://api.opencorporates.com/documentation/API-Reference
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OpenSanctions
- **Description**: Data on international sanctions, crime and politically exposed persons
- **Documentation**: https://www.opensanctions.org/docs/api/
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### PeakMetrics
- **Description**: News articles and public datasets
- **Documentation**: https://rapidapi.com/peakmetrics-peakmetrics-default/api/peakmetrics-news
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Recreation Information Database
- **Description**: Recreational areas, federal lands, historic sites, museums, and other attractions/resources(US)
- **Documentation**: https://ridb.recreation.gov/
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Scoop.it
- **Description**: Content Curation Service
- **Documentation**: http://www.scoop.it/dev
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Socrata
- **Description**: Access to Open Data from Governments, Non-profits and NGOs around the world
- **Documentation**: https://dev.socrata.com/
- **Category**: Open Data
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Teleport
- **Description**: Quality of Life Data
- **Documentation**: https://developers.teleport.org/
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Umeå Open Data
- **Description**: Open data of the city Umeå in northen Sweden
- **Documentation**: https://opendata.umea.se/api/
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Universities List
- **Description**: University names, countries and domains
- **Documentation**: https://github.com/Hipo/university-domains-list
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### University of Oslo
- **Description**: Courses, lecture videos, detailed information for courses etc. for the University of Oslo (Norway)
- **Documentation**: https://data.uio.no/
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### UPC database
- **Description**: More than 1.5 million barcode numbers from all around the world
- **Documentation**: https://upcdatabase.org/api
- **Category**: Open Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Urban Observatory
- **Description**: The largest set of publicly available real time urban data in the UK
- **Documentation**: https://urbanobservatory.ac.uk
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: No

### Wikidata
- **Description**: Collaboratively edited knowledge base operated by the Wikimedia Foundation
- **Documentation**: https://www.wikidata.org/w/api.php?action=help
- **Category**: Open Data
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Wikipedia
- **Description**: Mediawiki Encyclopedia
- **Documentation**: https://www.mediawiki.org/wiki/API:Main_page
- **Category**: Open Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Yelp
- **Description**: Find Local Business
- **Documentation**: https://www.yelp.com/developers/documentation/v3
- **Category**: Open Data
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Open Source Projects

### Countly
- **Description**: Countly web analytics
- **Documentation**: https://api.count.ly/reference
- **Category**: Open Source Projects
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Creative Commons Catalog
- **Description**: Search among openly licensed and public domain works
- **Documentation**: https://api.creativecommons.engineering/
- **Category**: Open Source Projects
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Datamuse
- **Description**: Word-finding query engine
- **Documentation**: https://www.datamuse.com/api/
- **Category**: Open Source Projects
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Drupal.org
- **Description**: Drupal.org
- **Documentation**: https://www.drupal.org/drupalorg/docs/api
- **Category**: Open Source Projects
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Evil Insult Generator
- **Description**: Evil Insults
- **Documentation**: https://evilinsult.com/api
- **Category**: Open Source Projects
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### GitHub Contribution Chart Generator
- **Description**: Create an image of your GitHub contributions
- **Documentation**: https://github-contributions.vercel.app
- **Category**: Open Source Projects
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### GitHub ReadMe Stats
- **Description**: Add dynamically generated statistics to your GitHub profile ReadMe
- **Documentation**: https://github.com/anuraghazra/github-readme-stats
- **Category**: Open Source Projects
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Metabase
- **Description**: An open source Business Intelligence server to share data and analytics inside your company
- **Documentation**: https://www.metabase.com/
- **Category**: Open Source Projects
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Shields
- **Description**: Concise, consistent, and legible badges in SVG and raster format
- **Documentation**: https://shields.io/
- **Category**: Open Source Projects
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Patent

### EPO
- **Description**: European patent search system api
- **Documentation**: https://developers.epo.org/
- **Category**: Patent
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### PatentsView 
- **Description**: API is intended to explore and visualize trends/patterns across the US innovation landscape
- **Documentation**: https://patentsview.org/apis/purpose
- **Category**: Patent
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### TIPO
- **Description**: Taiwan patent search system api
- **Documentation**: https://tiponet.tipo.gov.tw/Gazette/OpenData/OD/OD05.aspx?QryDS=API00
- **Category**: Patent
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### USPTO
- **Description**: USA patent api services
- **Documentation**: https://www.uspto.gov/learning-and-resources/open-data-and-mobility
- **Category**: Patent
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Personality

### Advice Slip
- **Description**: Generate random advice slips
- **Documentation**: http://api.adviceslip.com/
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Biriyani As A Service
- **Description**: Biriyani images placeholder
- **Documentation**: https://biriyani.anoram.com/
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Dev.to
- **Description**: Access Forem articles, users and other resources via API
- **Documentation**: https://developers.forem.com/api
- **Category**: Personality
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Dictum
- **Description**: API to get access to the collection of the most inspiring expressions of mankind
- **Documentation**: https://github.com/fisenkodv/dictum
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### FavQs.com
- **Description**: FavQs allows you to collect, discover and share your favorite quotes
- **Documentation**: https://favqs.com/api
- **Category**: Personality
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### FOAAS
- **Description**: Fuck Off As A Service
- **Documentation**: http://www.foaas.com/
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Forismatic
- **Description**: Inspirational Quotes
- **Documentation**: http://forismatic.com/en/api/
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### icanhazdadjoke
- **Description**: The largest selection of dad jokes on the internet
- **Documentation**: https://icanhazdadjoke.com/api
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Inspiration
- **Description**: Motivational and Inspirational quotes
- **Documentation**: https://inspiration.goprogram.ai/docs/
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### kanye.rest
- **Description**: REST API for random Kanye West quotes
- **Documentation**: https://kanye.rest
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### kimiquotes
- **Description**: Team radio and interview quotes by Finnish F1 legend Kimi Räikkönen
- **Documentation**: https://kimiquotes.herokuapp.com/doc
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Medium
- **Description**: Community of readers and writers offering unique perspectives on ideas
- **Documentation**: https://github.com/Medium/medium-api-docs
- **Category**: Personality
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Programming Quotes
- **Description**: Programming Quotes API for open source projects
- **Documentation**: https://github.com/skolakoda/programming-quotes-api
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Quotable Quotes
- **Description**: Quotable is a free, open source quotations API
- **Documentation**: https://github.com/lukePeavey/quotable
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Quote Garden
- **Description**: REST API for more than 5000 famous quotes
- **Documentation**: https://pprathameshmore.github.io/QuoteGarden/
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### quoteclear
- **Description**: Ever-growing list of James Clear quotes from the 3-2-1 Newsletter
- **Documentation**: https://quoteclear.web.app/
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Quotes on Design
- **Description**: Inspirational Quotes
- **Documentation**: https://quotesondesign.com/api/
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Stoicism Quote
- **Description**: Quotes about Stoicism
- **Documentation**: https://github.com/tlcheah2/stoic-quote-lambda-public-api
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### They Said So Quotes
- **Description**: Quotes Trusted by many fortune brands around the world
- **Documentation**: https://theysaidso.com/api/
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Traitify
- **Description**: Assess, collect and analyze Personality
- **Documentation**: https://app.traitify.com/developer
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Udemy(instructor)
- **Description**: API for instructors on Udemy
- **Documentation**: https://www.udemy.com/developers/instructor/
- **Category**: Personality
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Vadivelu HTTP Codes
- **Description**: On demand HTTP Codes with images
- **Documentation**: https://vadivelu.anoram.com/
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Zen Quotes
- **Description**: Large collection of Zen quotes for inspiration
- **Documentation**: https://zenquotes.io/
- **Category**: Personality
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

---

## Phone

### Phone Validation
- **Description**: Validate phone numbers globally
- **Documentation**: https://www.abstractapi.com/phone-validation-api
- **Category**: Phone
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### apilayer numverify
- **Description**: Phone number validation
- **Documentation**: https://numverify.com
- **Category**: Phone
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Cloudmersive Validate
- **Description**: Validate international phone numbers
- **Documentation**: https://cloudmersive.com/phone-number-validation-API
- **Category**: Phone
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Phone Specification
- **Description**: Rest Api for Phone specifications
- **Documentation**: https://github.com/azharimm/phone-specs-api
- **Category**: Phone
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Veriphone
- **Description**: Phone number validation & carrier lookup
- **Documentation**: https://veriphone.io
- **Category**: Phone
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

---

## Photography

### apilayer screenshotlayer
- **Description**: URL 2 Image
- **Documentation**: https://screenshotlayer.com
- **Category**: Photography
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### APITemplate.io
- **Description**: Dynamically generate images and PDFs from templates with a simple API
- **Documentation**: https://apitemplate.io
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Bruzu
- **Description**: Image generation with query string
- **Documentation**: https://docs.bruzu.com
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### CheetahO
- **Description**: Photo optimization and resize
- **Documentation**: https://cheetaho.com/docs/getting-started/
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Dagpi
- **Description**: Image manipulation and processing
- **Documentation**: https://dagpi.xyz
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Duply
- **Description**: Generate, Edit, Scale and Manage Images and Videos Smarter & Faster
- **Documentation**: https://duply.co/docs#getting-started-api
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### DynaPictures
- **Description**: Generate Hundreds of Personalized Images in Minutes
- **Documentation**: https://dynapictures.com/docs/
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Flickr
- **Description**: Flickr Services
- **Documentation**: https://www.flickr.com/services/api/
- **Category**: Photography
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Getty Images
- **Description**: Build applications using the world's most powerful imagery
- **Documentation**: http://developers.gettyimages.com/en/
- **Category**: Photography
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Gfycat
- **Description**: Jiffier GIFs
- **Documentation**: https://developers.gfycat.com/api/
- **Category**: Photography
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Giphy
- **Description**: Get all your gifs
- **Documentation**: https://developers.giphy.com/docs/
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Google Photos
- **Description**: Integrate Google Photos with your apps or devices
- **Documentation**: https://developers.google.com/photos
- **Category**: Photography
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Image Upload
- **Description**: Image Optimization
- **Documentation**: https://apilayer.com/marketplace/image_upload-api
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Imgur
- **Description**: Images
- **Documentation**: https://apidocs.imgur.com/
- **Category**: Photography
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Imsea
- **Description**: Free image search
- **Documentation**: https://imsea.herokuapp.com/
- **Category**: Photography
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Lorem Picsum
- **Description**: Images from Unsplash
- **Documentation**: https://picsum.photos/
- **Category**: Photography
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### ObjectCut
- **Description**: Image Background removal
- **Documentation**: https://objectcut.com/
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Pexels
- **Description**: Free Stock Photos and Videos
- **Documentation**: https://www.pexels.com/api/
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### PhotoRoom
- **Description**: Remove background from images
- **Documentation**: https://www.photoroom.com/api/
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Pixabay
- **Description**: Photography
- **Documentation**: https://pixabay.com/sk/service/about/api/
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### PlaceKeanu
- **Description**: Resizable Keanu Reeves placeholder images with grayscale and young Keanu options
- **Documentation**: https://placekeanu.com/
- **Category**: Photography
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Readme typing SVG
- **Description**: Customizable typing and deleting text SVG
- **Documentation**: https://github.com/DenverCoder1/readme-typing-svg
- **Category**: Photography
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Remove.bg
- **Description**: Image Background removal
- **Documentation**: https://www.remove.bg/api
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ReSmush.it
- **Description**: Photo optimization
- **Documentation**: https://resmush.it/api
- **Category**: Photography
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### shutterstock
- **Description**: Stock Photos and Videos
- **Documentation**: https://api-reference.shutterstock.com/
- **Category**: Photography
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Sirv
- **Description**: Image management solutions like optimization, manipulation, hosting
- **Documentation**: https://apidocs.sirv.com/
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Unsplash
- **Description**: Photography
- **Documentation**: https://unsplash.com/developers
- **Category**: Photography
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Wallhaven
- **Description**: Wallpapers
- **Documentation**: https://wallhaven.cc/help/api
- **Category**: Photography
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Webdam
- **Description**: Images
- **Documentation**: https://www.damsuccess.com/hc/en-us/articles/202134055-REST-API
- **Category**: Photography
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Programming

### Codeforces
- **Description**: Get access to Codeforces data
- **Documentation**: https://codeforces.com/apiHelp
- **Category**: Programming
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Hackerearth
- **Description**: For compiling and running code in several languages
- **Documentation**: https://www.hackerearth.com/docs/wiki/developers/v4/
- **Category**: Programming
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Judge0 CE
- **Description**: Online code execution system
- **Documentation**: https://ce.judge0.com/
- **Category**: Programming
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### KONTESTS
- **Description**: For upcoming and ongoing competitive coding contests
- **Documentation**: https://kontests.net/api
- **Category**: Programming
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Mintlify
- **Description**: For programmatically generating documentation for code
- **Documentation**: https://docs.mintlify.com
- **Category**: Programming
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

---

## Science & Math

### arcsecond.io
- **Description**: Multiple astronomy data sources
- **Documentation**: https://api.arcsecond.io/
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### arXiv
- **Description**: Curated research-sharing platform: physics, mathematics, quantitative finance, and economics
- **Documentation**: https://arxiv.org/help/api/user-manual
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### CORE
- **Description**: Access the world's Open Access research papers
- **Documentation**: https://core.ac.uk/services#api
- **Category**: Science & Math
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### GBIF
- **Description**: Global Biodiversity Information Facility
- **Documentation**: https://www.gbif.org/developer/summary
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### iDigBio
- **Description**: Access millions of museum specimens from organizations around the world
- **Documentation**: https://github.com/idigbio/idigbio-search-api/wiki
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### inspirehep.net
- **Description**: High Energy Physics info. system
- **Documentation**: https://github.com/inspirehep/rest-api-doc
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### isEven (humor)
- **Description**: Check if a number is even
- **Documentation**: https://isevenapi.xyz/
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### ISRO
- **Description**: ISRO Space Crafts Information
- **Documentation**: https://isro.vercel.app
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### ITIS
- **Description**: Integrated Taxonomic Information System
- **Documentation**: https://www.itis.gov/ws_description.html
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Launch Library 2
- **Description**: Spaceflight launches and events database
- **Documentation**: https://thespacedevs.com/llapi
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Materials Platform for Data Science
- **Description**: Curated experimental data for materials science
- **Documentation**: https://mpds.io
- **Category**: Science & Math
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Minor Planet Center
- **Description**: Asterank.com Information
- **Documentation**: http://www.asterank.com/mpc
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### NASA
- **Description**: NASA data, including imagery
- **Documentation**: https://api.nasa.gov
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### NASA ADS
- **Description**: NASA Astrophysics Data System
- **Documentation**: https://ui.adsabs.harvard.edu/help/api/api-docs.html
- **Category**: Science & Math
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Newton
- **Description**: Symbolic and Arithmetic Math Calculator
- **Documentation**: https://newton.vercel.app
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Noctua
- **Description**: REST API used to access NoctuaSky features
- **Documentation**: https://api.noctuasky.com/api/v1/swaggerdoc/
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Numbers
- **Description**: Number of the day, random number, number facts and anything else you want to do with numbers
- **Documentation**: https://math.tools/api/numbers/
- **Category**: Science & Math
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Numbers
- **Description**: Facts about numbers
- **Documentation**: http://numbersapi.com
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: No

### Ocean Facts
- **Description**: Facts pertaining to the physical science of Oceanography
- **Documentation**: https://oceanfacts.herokuapp.com/
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Notify
- **Description**: ISS astronauts, current location, etc
- **Documentation**: http://open-notify.org/Open-Notify-API/
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: No

### Open Science Framework
- **Description**: Repository and archive for study designs, research materials, data, manuscripts, etc
- **Documentation**: https://developer.osf.io
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Purple Air
- **Description**: Real Time Air Quality Monitoring
- **Documentation**: https://www2.purpleair.com/
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Remote Calc
- **Description**: Decodes base64 encoding and parses it to return a solution to the calculation in JSON
- **Documentation**: https://github.com/elizabethadegbaju/remotecalc
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### SHARE
- **Description**: A free, open, dataset about research and scholarly activities
- **Documentation**: https://share.osf.io/api/v2/
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### SpaceX
- **Description**: Company, vehicle, launchpad and launch data
- **Documentation**: https://github.com/r-spacex/SpaceX-API
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### SpaceX
- **Description**: GraphQL, Company, Ships, launchpad and launch data
- **Documentation**: https://api.spacex.land/graphql/
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Sunrise and Sunset
- **Description**: Sunset and sunrise times for a given latitude and longitude
- **Documentation**: https://sunrise-sunset.org/api
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Times Adder
- **Description**: With this API you can add each of the times introduced in the array sended
- **Documentation**: https://github.com/FranP-code/API-Times-Adder
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### TLE
- **Description**: Satellite information
- **Documentation**: https://tle.ivanstanojevic.me/#/docs
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### USGS Earthquake Hazards Program
- **Description**: Earthquakes data real-time
- **Documentation**: https://earthquake.usgs.gov/fdsnws/event/1/
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### USGS Water Services
- **Description**: Water quality and level info for rivers and lakes
- **Documentation**: https://waterservices.usgs.gov/
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### World Bank
- **Description**: World Data
- **Documentation**: https://datahelpdesk.worldbank.org/knowledgebase/topics/125589
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### xMath
- **Description**: Random mathematical expressions
- **Documentation**: https://x-math.herokuapp.com/
- **Category**: Science & Math
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

---

## Security

### Application Environment Verification
- **Description**: Android library and API to verify the safety of user devices, detect rooted devices and other risks
- **Documentation**: https://github.com/fingerprintjs/aev
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### BinaryEdge
- **Description**: Provide access to BinaryEdge 40fy scanning platform
- **Documentation**: https://docs.binaryedge.io/api-v2.html
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### BitWarden
- **Description**: Best open-source password manager
- **Documentation**: https://bitwarden.com/help/api/
- **Category**: Security
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Botd
- **Description**: Botd is a browser library for JavaScript bot detection
- **Documentation**: https://github.com/fingerprintjs/botd
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Bugcrowd
- **Description**: Bugcrowd API for interacting and tracking the reported issues programmatically
- **Documentation**: https://docs.bugcrowd.com/api/getting-started/
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Censys
- **Description**: Search engine for Internet connected host and devices
- **Documentation**: https://search.censys.io/api
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Classify
- **Description**: Encrypting & decrypting text messages
- **Documentation**: https://classify-web.herokuapp.com/#/api
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Complete Criminal Checks
- **Description**: Provides data of offenders from all U.S. States and Pureto Rico
- **Documentation**: https://completecriminalchecks.com/Developers
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### CRXcavator
- **Description**: Chrome extension risk scoring
- **Documentation**: https://crxcavator.io/apidocs
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Dehash.lt
- **Description**: Hash decryption MD5, SHA1, SHA3, SHA256, SHA384, SHA512
- **Documentation**: https://github.com/Dehash-lt/api
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### EmailRep
- **Description**: Email address threat and risk prediction
- **Documentation**: https://docs.emailrep.io/
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Escape
- **Description**: An API for escaping different kind of queries
- **Documentation**: https://github.com/polarspetroll/EscapeAPI
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### FilterLists
- **Description**: Lists of filters for adblockers and firewalls
- **Documentation**: https://filterlists.com
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### FingerprintJS Pro
- **Description**: Fraud detection API offering highly accurate browser fingerprinting
- **Documentation**: https://dev.fingerprintjs.com/docs
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### FraudLabs Pro
- **Description**: Screen order information using AI to detect frauds
- **Documentation**: https://www.fraudlabspro.com/developer/api/screen-order
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### FullHunt
- **Description**: Searchable attack surface database of the entire internet
- **Documentation**: https://api-docs.fullhunt.io/#introduction
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### GitGuardian
- **Description**: Scan files for secrets (API Keys, database credentials)
- **Documentation**: https://api.gitguardian.com/doc
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### GreyNoise
- **Description**: Query IPs in the GreyNoise dataset and retrieve a subset of the full IP context data
- **Documentation**: https://docs.greynoise.io/reference/get_v3-community-ip
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### HackerOne
- **Description**: The industry’s first hacker API that helps increase productivity towards creative bug bounty hunting
- **Documentation**: https://api.hackerone.com/
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Hashable
- **Description**: A REST API to access high level cryptographic functions and methods
- **Documentation**: https://hashable.space/pages/api/
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### HaveIBeenPwned
- **Description**: Passwords which have previously been exposed in data breaches
- **Documentation**: https://haveibeenpwned.com/API/v3
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Intelligence X
- **Description**: Perform OSINT via Intelligence X
- **Documentation**: https://github.com/IntelligenceX/SDK/blob/master/Intelligence%20X%20API.pdf
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### LoginRadius
- **Description**: Managed User Authentication Service
- **Documentation**: https://www.loginradius.com/docs/
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Microsoft Security Response Center (MSRC)
- **Description**: Programmatic interfaces to engage with the Microsoft Security Response Center (MSRC)
- **Documentation**: https://msrc.microsoft.com/report/developer
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Mozilla http scanner
- **Description**: Mozilla observatory http scanner
- **Documentation**: https://github.com/mozilla/http-observatory/blob/master/httpobs/docs/api.md
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Mozilla tls scanner
- **Description**: Mozilla observatory tls scanner
- **Documentation**: https://github.com/mozilla/tls-observatory#api-endpoints
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### National Vulnerability Database
- **Description**: U.S. National Vulnerability Database
- **Documentation**: https://nvd.nist.gov/vuln/Data-Feeds/JSON-feed-changelog
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Passwordinator
- **Description**: Generate random passwords of varying complexities
- **Documentation**: https://github.com/fawazsullia/password-generator/
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### PhishStats
- **Description**: Phishing database
- **Documentation**: https://phishstats.info/
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Privacy.com
- **Description**: Generate merchant-specific and one-time use credit card numbers that link back to your bank
- **Documentation**: https://privacy.com/developer/docs
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Pulsedive
- **Description**: Scan, search and collect threat intelligence data in real-time
- **Documentation**: https://pulsedive.com/api/
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### SecurityTrails
- **Description**: Domain and IP related information such as current and historical WHOIS and DNS records
- **Documentation**: https://securitytrails.com/corp/apidocs
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Shodan
- **Description**: Search engine for Internet connected devices
- **Documentation**: https://developer.shodan.io/
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Spyse
- **Description**: Access data on all Internet assets and build powerful attack surface management applications
- **Documentation**: https://spyse-dev.readme.io/reference/quick-start
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Threat Jammer
- **Description**: Risk scoring service from curated threat intelligence data
- **Documentation**: https://threatjammer.com/docs/index
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### UK Police
- **Description**: UK Police data
- **Documentation**: https://data.police.uk/docs/
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Virushee
- **Description**: Virushee file/data scanning
- **Documentation**: https://api.virushee.com/
- **Category**: Security
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### VulDB
- **Description**: VulDB API allows to initiate queries for one or more items along with transactional bots
- **Documentation**: https://vuldb.com/?doc.api
- **Category**: Security
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Shopping

### Best Buy
- **Description**: Products, Buying Options, Categories, Recommendations, Stores and Commerce
- **Documentation**: https://bestbuyapis.github.io/api-documentation/#overview
- **Category**: Shopping
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Digi-Key
- **Description**: Retrieve price and inventory of electronic components as well as place orders
- **Documentation**: https://www.digikey.com/en/resources/api-solutions
- **Category**: Shopping
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Dummy Products
- **Description**: An api to fetch dummy e-commerce products JSON data with placeholder images
- **Documentation**: https://dummyproducts-api.herokuapp.com/
- **Category**: Shopping
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### eBay
- **Description**: Sell and Buy on eBay
- **Documentation**: https://developer.ebay.com/
- **Category**: Shopping
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Etsy
- **Description**: Manage shop and interact with listings
- **Documentation**: https://www.etsy.com/developers/documentation/getting_started/api_basics
- **Category**: Shopping
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Flipkart Marketplace
- **Description**: Product listing management, Order Fulfilment in the Flipkart Marketplace
- **Documentation**: https://seller.flipkart.com/api-docs/FMSAPI.html
- **Category**: Shopping
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Lazada
- **Description**: Retrieve product ratings and seller performance metrics
- **Documentation**: https://open.lazada.com/doc/doc.htm
- **Category**: Shopping
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Mercadolibre
- **Description**: Manage sales, ads, products, services and Shops
- **Documentation**: https://developers.mercadolibre.cl/es_ar/api-docs-es
- **Category**: Shopping
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Octopart
- **Description**: Electronic part data for manufacturing, design, and sourcing
- **Documentation**: https://octopart.com/api/v4/reference
- **Category**: Shopping
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OLX Poland
- **Description**: Integrate with local sites by posting, managing adverts and communicating with OLX users
- **Documentation**: https://developer.olx.pl/api/doc#section/
- **Category**: Shopping
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Rappi
- **Description**: Manage orders from Rappi's app
- **Documentation**: https://dev-portal.rappi.com/
- **Category**: Shopping
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Shopee
- **Description**: Shopee's official API for integration of various services from Shopee
- **Documentation**: https://open.shopee.com/documents?version=1
- **Category**: Shopping
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Tokopedia
- **Description**: Tokopedia's Official API for integration of various services from Tokopedia
- **Documentation**: https://developer.tokopedia.com/openapi/guide/#/
- **Category**: Shopping
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### WooCommerce
- **Description**: WooCommerce REST APIS to create, read, update, and delete data on wordpress website in JSON format
- **Documentation**: https://woocommerce.github.io/woocommerce-rest-api-docs/
- **Category**: Shopping
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

---

## Social

### 4chan
- **Description**: Simple image-based bulletin board dedicated to a variety of topics
- **Documentation**: https://github.com/4chan/4chan-API
- **Category**: Social
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Ayrshare
- **Description**: Social media APIs to post, get analytics, and manage multiple users social media accounts
- **Documentation**: https://www.ayrshare.com
- **Category**: Social
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### aztro
- **Description**: Daily horoscope info for yesterday, today, and tomorrow
- **Documentation**: https://aztro.sameerkumar.website/
- **Category**: Social
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Blogger
- **Description**: The Blogger APIs allows client applications to view and update Blogger content
- **Documentation**: https://developers.google.com/blogger/
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Cisco Spark
- **Description**: Team Collaboration Software
- **Documentation**: https://developer.ciscospark.com
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Dangerous Discord Database
- **Description**: Database of malicious Discord accounts
- **Documentation**: https://discord.riverside.rocks/docs/index.php
- **Category**: Social
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Discord
- **Description**: Make bots for Discord, integrate Discord onto an external platform
- **Documentation**: https://discord.com/developers/docs/intro
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Disqus
- **Description**: Communicate with Disqus data
- **Documentation**: https://disqus.com/api/docs/auth/
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Doge-Meme
- **Description**: Top meme posts from r/dogecoin which include 'Meme' flair
- **Documentation**: https://api.doge-meme.lol/docs
- **Category**: Social
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Facebook
- **Description**: Facebook Login, Share on FB, Social Plugins, Analytics and more
- **Documentation**: https://developers.facebook.com/
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Foursquare
- **Description**: Interact with Foursquare users and places (geolocation-based checkins, photos, tips, events, etc)
- **Documentation**: https://developer.foursquare.com/
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Fuck Off as a Service
- **Description**: Asks someone to fuck off
- **Documentation**: https://www.foaas.com
- **Category**: Social
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Full Contact
- **Description**: Get Social Media profiles and contact Information
- **Documentation**: https://docs.fullcontact.com/
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### HackerNews
- **Description**: Social news for CS and entrepreneurship
- **Documentation**: https://github.com/HackerNews/API
- **Category**: Social
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Hashnode
- **Description**: A blogging platform built for developers
- **Documentation**: https://hashnode.com
- **Category**: Social
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Instagram
- **Description**: Instagram Login, Share on Instagram, Social Plugins and more
- **Documentation**: https://www.instagram.com/developer/
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Kakao
- **Description**: Kakao Login, Share on KakaoTalk, Social Plugins and more
- **Documentation**: https://developers.kakao.com/
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Lanyard
- **Description**: Retrieve your presence on Discord through an HTTP REST API or WebSocket
- **Documentation**: https://github.com/Phineas/lanyard
- **Category**: Social
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Line
- **Description**: Line Login, Share on Line, Social Plugins and more
- **Documentation**: https://developers.line.biz/
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### LinkedIn
- **Description**: The foundation of all digital integrations with LinkedIn
- **Documentation**: https://docs.microsoft.com/en-us/linkedin/?context=linkedin/context
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Meetup.com
- **Description**: Data about Meetups from Meetup.com
- **Documentation**: https://www.meetup.com/api/guide
- **Category**: Social
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Microsoft Graph
- **Description**: Access the data and intelligence in Microsoft 365, Windows 10, and Enterprise Mobility
- **Documentation**: https://docs.microsoft.com/en-us/graph/api/overview
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### NAVER
- **Description**: NAVER Login, Share on NAVER, Social Plugins and more
- **Documentation**: https://developers.naver.com/main/
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Collective
- **Description**: Get Open Collective data
- **Documentation**: https://docs.opencollective.com/help/developers/api
- **Category**: Social
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Pinterest
- **Description**: The world's catalog of ideas
- **Documentation**: https://developers.pinterest.com/
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Product Hunt
- **Description**: The best new products in tech
- **Documentation**: https://api.producthunt.com/v2/docs
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Reddit
- **Description**: Homepage of the internet
- **Documentation**: https://www.reddit.com/dev/api
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Revolt
- **Description**: Revolt open source Discord alternative
- **Documentation**: https://developers.revolt.chat/api/
- **Category**: Social
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Saidit
- **Description**: Open Source Reddit Clone
- **Documentation**: https://www.saidit.net/dev/api
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Slack
- **Description**: Team Instant Messaging
- **Documentation**: https://api.slack.com/
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### TamTam
- **Description**: Bot API to interact with TamTam
- **Documentation**: https://dev.tamtam.chat/
- **Category**: Social
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Telegram Bot
- **Description**: Simplified HTTP version of the MTProto API for bots
- **Documentation**: https://core.telegram.org/bots/api
- **Category**: Social
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Telegram MTProto
- **Description**: Read and write Telegram data
- **Documentation**: https://core.telegram.org/api#getting-started
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Telegraph
- **Description**: Create attractive blogs easily, to share
- **Documentation**: https://telegra.ph/api
- **Category**: Social
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### TikTok
- **Description**: Fetches user info and user's video posts on TikTok platform
- **Documentation**: https://developers.tiktok.com/doc/login-kit-web
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Trash Nothing
- **Description**: A freecycling community with thousands of free items posted every day
- **Documentation**: https://trashnothing.com/developer
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Tumblr
- **Description**: Read and write Tumblr Data
- **Documentation**: https://www.tumblr.com/docs/en/api/v2
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Twitch
- **Description**: Game Streaming API
- **Documentation**: https://dev.twitch.tv/docs
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Twitter
- **Description**: Read and write Twitter data
- **Documentation**: https://developer.twitter.com/en/docs
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: No

### vk
- **Description**: Read and write vk data
- **Documentation**: https://vk.com/dev/sites
- **Category**: Social
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Sports & Fitness

### API-FOOTBALL
- **Description**: Get information about Football Leagues & Cups
- **Documentation**: https://www.api-football.com/documentation-v3
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### ApiMedic
- **Description**: ApiMedic offers a medical symptom checker API primarily for patients
- **Documentation**: https://apimedic.com/
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### balldontlie
- **Description**: Balldontlie provides access to stats data from the NBA
- **Documentation**: https://www.balldontlie.io
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Canadian Football League (CFL)
- **Description**: Official JSON API providing real-time league, team and player statistics about the CFL
- **Documentation**: http://api.cfl.ca/
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### City Bikes
- **Description**: City Bikes around the world
- **Documentation**: https://api.citybik.es/v2/
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Cloudbet
- **Description**: Official Cloudbet API provides real-time sports odds and betting API to place bets programmatically
- **Documentation**: https://www.cloudbet.com/api/
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### CollegeFootballData.com
- **Description**: Unofficial detailed American college football statistics, records, and results API
- **Documentation**: https://collegefootballdata.com
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Ergast F1
- **Description**: F1 data from the beginning of the world championships in 1950
- **Documentation**: http://ergast.com/mrd/
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Fitbit
- **Description**: Fitbit Information
- **Documentation**: https://dev.fitbit.com/
- **Category**: Sports & Fitness
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Football
- **Description**: A simple Open Source Football API to get squads’ stats, best scorers and more
- **Documentation**: https://rapidapi.com/GiulianoCrescimbeni/api/football98/
- **Category**: Sports & Fitness
- **Auth Type**: X-Mashape-Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Football (Soccer) Videos
- **Description**: Embed codes for goals and highlights from Premier League, Bundesliga, Serie A and many more
- **Documentation**: https://www.scorebat.com/video-api/
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Football Standings
- **Description**: Display football standings e.g epl, la liga, serie a etc. The data is based on espn site
- **Documentation**: https://github.com/azharimm/football-standings-api
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Football-Data
- **Description**: Football data with matches info, players, teams, and competitions
- **Documentation**: https://www.football-data.org
- **Category**: Sports & Fitness
- **Auth Type**: X-Mashape-Key
- **HTTPS**: Yes
- **CORS**: Unknown

### JCDecaux Bike
- **Description**: JCDecaux's self-service bicycles
- **Documentation**: https://developer.jcdecaux.com/
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### MLB Records and Stats
- **Description**: Current and historical MLB statistics
- **Documentation**: https://appac.github.io/mlb-data-api-docs/
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### NBA Data
- **Description**: All NBA Stats DATA, Games, Livescore, Standings, Statistics
- **Documentation**: https://rapidapi.com/api-sports/api/api-nba/
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### NBA Stats
- **Description**: Current and historical NBA Statistics
- **Documentation**: https://any-api.com/nba_com/nba_com/docs/API_Description
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### NHL Records and Stats
- **Description**: NHL historical data and statistics
- **Documentation**: https://gitlab.com/dword4/nhlapi
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Oddsmagnet
- **Description**: Odds history from multiple UK bookmakers
- **Documentation**: https://data.oddsmagnet.com
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### OpenLigaDB
- **Description**: Crowd sourced sports league results
- **Documentation**: https://www.openligadb.de
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Premier League Standings 
- **Description**: All Current Premier League Standings and Statistics
- **Documentation**: https://rapidapi.com/heisenbug/api/premier-league-live-scores/
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Sport Data
- **Description**: Get sports data from all over the world
- **Documentation**: https://sportdataapi.com
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Sport List & Data
- **Description**: List of and resources related to sports
- **Documentation**: https://developers.decathlon.com/products/sports
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Sport Places
- **Description**: Crowd-source sports places around the world
- **Documentation**: https://developers.decathlon.com/products/sport-places
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Sport Vision
- **Description**: Identify sport, brands and gear in an image. Also does image sports captioning
- **Documentation**: https://developers.decathlon.com/products/sport-vision
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Sportmonks Cricket
- **Description**: Live cricket score, player statistics and fantasy API
- **Documentation**: https://docs.sportmonks.com/cricket/
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Sportmonks Football
- **Description**: Football score/schedule, news api, tv channels, stats, history, display standing e.g. epl, la liga
- **Documentation**: https://docs.sportmonks.com/football/
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Squiggle
- **Description**: Fixtures, results and predictions for Australian Football League matches
- **Documentation**: https://api.squiggle.com.au
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Strava
- **Description**: Connect with athletes, activities and more
- **Documentation**: https://strava.github.io/api/
- **Category**: Sports & Fitness
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### SuredBits
- **Description**: Query sports data, including teams, players, games, scores and statistics
- **Documentation**: https://suredbits.com/api/
- **Category**: Sports & Fitness
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: No

### TheSportsDB
- **Description**: Crowd-Sourced Sports Data and Artwork
- **Documentation**: https://www.thesportsdb.com/api.php
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Tredict
- **Description**: Get and set activities, health data and more
- **Documentation**: https://www.tredict.com/blog/oauth_docs/
- **Category**: Sports & Fitness
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Wger
- **Description**: Workout manager data as exercises, muscles or equipment
- **Documentation**: https://wger.de/en/software/api
- **Category**: Sports & Fitness
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Test Data

### Bacon Ipsum
- **Description**: A Meatier Lorem Ipsum Generator
- **Documentation**: https://baconipsum.com/json-api/
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Dicebear Avatars
- **Description**: Generate random pixel-art avatars
- **Documentation**: https://avatars.dicebear.com/
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### English Random Words
- **Description**: Generate English Random Words with Pronunciation
- **Documentation**: https://random-words-api.vercel.app/word
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### FakeJSON
- **Description**: Service to generate test and fake data
- **Documentation**: https://fakejson.com
- **Category**: Test Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### FakerAPI
- **Description**: APIs collection to get fake data
- **Documentation**: https://fakerapi.it/en
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### FakeStoreAPI
- **Description**: Fake store rest API for your e-commerce or shopping website prototype
- **Documentation**: https://fakestoreapi.com/
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### GeneradorDNI
- **Description**: Data generator API. Profiles, vehicles, banks and cards, etc
- **Documentation**: https://api.generadordni.es
- **Category**: Test Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ItsThisForThat
- **Description**: Generate Random startup ideas
- **Documentation**: https://itsthisforthat.com/api.php
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### JSONPlaceholder
- **Description**: Fake data for testing and prototyping
- **Documentation**: http://jsonplaceholder.typicode.com/
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Loripsum
- **Description**: The "lorem ipsum" generator that doesn't suck
- **Documentation**: http://loripsum.net/
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Mailsac
- **Description**: Disposable Email
- **Documentation**: https://mailsac.com/docs/api
- **Category**: Test Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Metaphorsum
- **Description**: Generate demo paragraphs giving number of words and sentences
- **Documentation**: http://metaphorpsum.com/
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Mockaroo
- **Description**: Generate fake data to JSON, CSV, TXT, SQL and XML
- **Documentation**: https://www.mockaroo.com/docs
- **Category**: Test Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### QuickMocker
- **Description**: API mocking tool to generate contextual, fake or random data
- **Documentation**: https://quickmocker.com
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Random Data
- **Description**: Random data generator
- **Documentation**: https://random-data-api.com
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Randommer
- **Description**: Random data generator
- **Documentation**: https://randommer.io/randommer-api
- **Category**: Test Data
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### RandomUser
- **Description**: Generates and list user data
- **Documentation**: https://randomuser.me
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### RoboHash
- **Description**: Generate random robot/alien avatars
- **Documentation**: https://robohash.org/
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Spanish random names
- **Description**: Generate spanish names (with gender) randomly
- **Documentation**: https://random-names-api.herokuapp.com/public
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Spanish random words
- **Description**: Generate spanish words randomly
- **Documentation**: https://palabras-aleatorias-public-api.herokuapp.com
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### This Person Does not Exist
- **Description**: Generates real-life faces of people who do not exist
- **Documentation**: https://thispersondoesnotexist.com
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Toolcarton
- **Description**: Generate random testimonial data
- **Documentation**: https://testimonialapi.toolcarton.com/
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### UUID Generator
- **Description**: Generate UUIDs
- **Documentation**: https://www.uuidtools.com/docs
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### What The Commit
- **Description**: Random commit message generator
- **Documentation**: http://whatthecommit.com/index.txt
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Yes

### Yes No
- **Description**: Generate yes or no randomly
- **Documentation**: https://yesno.wtf/api
- **Category**: Test Data
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Text Analysis

### Code Detection API
- **Description**: Detect, label, format and enrich the code in your app or in your data pipeline
- **Documentation**: https://codedetectionapi.runtime.dev
- **Category**: Text Analysis
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### apilayer languagelayer
- **Description**: Language Detection JSON API supporting 173 languages
- **Documentation**: https://languagelayer.com/
- **Category**: Text Analysis
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Aylien Text Analysis
- **Description**: A collection of information retrieval and natural language APIs
- **Documentation**: https://docs.aylien.com/textapi/#getting-started
- **Category**: Text Analysis
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Cloudmersive Natural Language Processing
- **Description**: Natural language processing and text analysis
- **Documentation**: https://www.cloudmersive.com/nlp-api
- **Category**: Text Analysis
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Detect Language
- **Description**: Detects text language
- **Documentation**: https://detectlanguage.com/
- **Category**: Text Analysis
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ELI
- **Description**: Natural Language Processing Tools for Thai Language
- **Documentation**: https://nlp.insightera.co.th/docs/v1.0
- **Category**: Text Analysis
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Google Cloud Natural
- **Description**: Natural language understanding technology, including sentiment, entity and syntax analysis
- **Documentation**: https://cloud.google.com/natural-language/docs/
- **Category**: Text Analysis
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Hirak OCR
- **Description**: Image to text -text recognition- from image more than 100 language, accurate, unlimited requests
- **Documentation**: https://ocr.hirak.site/
- **Category**: Text Analysis
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Hirak Translation
- **Description**: Translate between 21 of most used languages, accurate, unlimited requests
- **Documentation**: https://translate.hirak.site/
- **Category**: Text Analysis
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Lecto Translation
- **Description**: Translation API with free tier and reasonable prices
- **Documentation**: https://rapidapi.com/lecto-lecto-default/api/lecto-translation/
- **Category**: Text Analysis
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### LibreTranslate
- **Description**: Translation tool with 17 available languages
- **Documentation**: https://libretranslate.com/docs
- **Category**: Text Analysis
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Semantria
- **Description**: Text Analytics with sentiment analysis, categorization & named entity extraction
- **Documentation**: https://semantria.readme.io/docs
- **Category**: Text Analysis
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Sentiment Analysis
- **Description**: Multilingual sentiment analysis of texts from different sources
- **Documentation**: https://www.meaningcloud.com/developer/sentiment-analysis
- **Category**: Text Analysis
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Tisane
- **Description**: Text Analytics with focus on detection of abusive content and law enforcement applications
- **Documentation**: https://tisane.ai/
- **Category**: Text Analysis
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Watson Natural Language Understanding
- **Description**: Natural language processing for advanced text analysis
- **Documentation**: https://cloud.ibm.com/apidocs/natural-language-understanding/natural-language-understanding
- **Category**: Text Analysis
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Tracking

### Aftership
- **Description**: API to update, manage and track shipment efficiently
- **Documentation**: https://developers.aftership.com/reference/quick-start
- **Category**: Tracking
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Correios
- **Description**: Integration to provide information and prepare shipments using Correio's services
- **Documentation**: https://cws.correios.com.br/ajuda
- **Category**: Tracking
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Pixela
- **Description**: API for recording and tracking habits or effort, routines
- **Documentation**: https://pixe.la
- **Category**: Tracking
- **Auth Type**: X-Mashape-Key
- **HTTPS**: Yes
- **CORS**: Yes

### PostalPinCode
- **Description**: API for getting Pincode details in India
- **Documentation**: http://www.postalpincode.in/Api-Details
- **Category**: Tracking
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Postmon
- **Description**: An API to query Brazilian ZIP codes and orders easily, quickly and free
- **Documentation**: http://postmon.com.br
- **Category**: Tracking
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### PostNord
- **Description**: Provides information about parcels in transport for Sweden and Denmark
- **Documentation**: https://developer.postnord.com/api
- **Category**: Tracking
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### UPS
- **Description**: Shipment and Address information
- **Documentation**: https://www.ups.com/upsdeveloperkit
- **Category**: Tracking
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### WeCanTrack
- **Description**: Automatically place subids in affiliate links to attribute affiliate conversions to click data
- **Documentation**: https://docs.wecantrack.com
- **Category**: Tracking
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### WhatPulse
- **Description**: Small application that measures your keyboard/mouse usage
- **Documentation**: https://developer.whatpulse.org/#web-api
- **Category**: Tracking
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Transportation

### ADS-B Exchange
- **Description**: Access real-time and historical data of any and all airborne aircraft
- **Documentation**: https://www.adsbexchange.com/data/
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### airportsapi
- **Description**: Get name and website-URL for airports by ICAO code
- **Documentation**: https://airport-web.appspot.com/api/docs/
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### AIS Hub
- **Description**: Real-time data of any marine and inland vessel equipped with AIS tracking system
- **Documentation**: http://www.aishub.net/api
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Amadeus for Developers
- **Description**: Travel Search - Limited usage
- **Documentation**: https://developers.amadeus.com/self-service
- **Category**: Transportation
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### apilayer aviationstack
- **Description**: Real-time Flight Status & Global Aviation Data API
- **Documentation**: https://aviationstack.com/
- **Category**: Transportation
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### AviationAPI
- **Description**: FAA Aeronautical Charts and Publications, Airport Information, and Airport Weather
- **Documentation**: https://docs.aviationapi.com
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### AZ511
- **Description**: Access traffic data from the ADOT API
- **Documentation**: https://www.az511.com/developers/doc
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Bay Area Rapid Transit
- **Description**: Stations and predicted arrivals for BART
- **Documentation**: http://api.bart.gov
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### BC Ferries
- **Description**: Sailing times and capacities for BC Ferries
- **Documentation**: https://www.bcferriesapi.ca
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### BIC-Boxtech
- **Description**: Container technical detail for the global container fleet
- **Documentation**: https://docs.bic-boxtech.org/
- **Category**: Transportation
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### BlaBlaCar
- **Description**: Search car sharing trips
- **Documentation**: https://dev.blablacar.com
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Boston MBTA Transit
- **Description**: Stations and predicted arrivals for MBTA
- **Documentation**: https://www.mbta.com/developers/v3-api
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Community Transit
- **Description**: Transitland API
- **Documentation**: https://github.com/transitland/transitland-datastore/blob/master/README.md#api-endpoints
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Compare Flight Prices
- **Description**: API for comparing flight prices across platforms
- **Documentation**: https://rapidapi.com/obryan-software-obryan-software-default/api/compare-flight-prices/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### CTS
- **Description**: CTS Realtime API
- **Documentation**: https://api.cts-strasbourg.eu/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Grab
- **Description**: Track deliveries, ride fares, payments and loyalty points
- **Documentation**: https://developer.grab.com/docs/
- **Category**: Transportation
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### GraphHopper
- **Description**: A-to-B routing with turn-by-turn instructions
- **Documentation**: https://docs.graphhopper.com/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Icelandic APIs
- **Description**: Open APIs that deliver services in or regarding Iceland
- **Documentation**: http://docs.apis.is/
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Impala Hotel Bookings
- **Description**: Hotel content, rates and room bookings
- **Documentation**: https://docs.impala.travel/docs/booking-api/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Izi
- **Description**: Audio guide for travellers
- **Documentation**: http://api-docs.izi.travel/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Land Transport Authority DataMall, Singapore
- **Description**: Singapore transport information
- **Documentation**: https://datamall.lta.gov.sg/content/dam/datamall/datasets/LTA_DataMall_API_User_Guide.pdf
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Metro Lisboa
- **Description**: Delays in subway lines
- **Documentation**: http://app.metrolisboa.pt/status/getLinhas.php
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: No

### Navitia
- **Description**: The open API for building cool stuff with transport data
- **Documentation**: https://doc.navitia.io/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Open Charge Map
- **Description**: Global public registry of electric vehicle charging locations
- **Documentation**: https://openchargemap.org/site/develop/api
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### OpenSky Network
- **Description**: Free real-time ADS-B aviation data
- **Documentation**: https://opensky-network.org/apidoc/index.html
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Railway Transport for France
- **Description**: SNCF public API
- **Documentation**: https://www.digital.sncf.com/startup/api
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### REFUGE Restrooms
- **Description**: Provides safe restroom access for transgender, intersex and gender nonconforming individuals
- **Documentation**: https://www.refugerestrooms.org/api/docs/#!/restrooms
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Sabre for Developers
- **Description**: Travel Search - Limited usage
- **Documentation**: https://developer.sabre.com/guides/travel-agency/quickstart/getting-started-in-travel
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Schiphol Airport
- **Description**: Schiphol
- **Documentation**: https://developer.schiphol.nl/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Tankerkoenig
- **Description**: German realtime gas/diesel prices
- **Documentation**: https://creativecommons.tankerkoenig.de/swagger/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### TransitLand
- **Description**: Transit Aggregation
- **Documentation**: https://www.transit.land/documentation/datastore/api-endpoints.html
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Atlanta, US
- **Description**: Marta
- **Documentation**: http://www.itsmarta.com/app-developer-resources.aspx
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Transport for Auckland, New Zealand
- **Description**: Auckland Transport
- **Documentation**: https://dev-portal.at.govt.nz/
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Belgium
- **Description**: The iRail API is a third-party API for Belgian public transport by train
- **Documentation**: https://docs.irail.be/
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Transport for Berlin, Germany
- **Description**: Third-party VBB API
- **Documentation**: https://github.com/derhuerst/vbb-rest/blob/3/docs/index.md
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Bordeaux, France
- **Description**: Bordeaux Métropole public transport and more (France)
- **Documentation**: https://opendata.bordeaux-metropole.fr/explore/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Budapest, Hungary
- **Description**: Budapest public transport API
- **Documentation**: https://bkkfutar.docs.apiary.io
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Chicago, US
- **Description**: Chicago Transit Authority (CTA)
- **Documentation**: http://www.transitchicago.com/developers/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Transport for Czech Republic
- **Description**: Czech transport API
- **Documentation**: https://www.chaps.cz/eng/products/idos-internet
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Denver, US
- **Description**: RTD
- **Documentation**: http://www.rtd-denver.com/gtfs-developer-guide.shtml
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Transport for Finland
- **Description**: Finnish transport API
- **Documentation**: https://digitransit.fi/en/developers/ 
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Germany
- **Description**: Deutsche Bahn (DB) API
- **Documentation**: http://data.deutschebahn.com/dataset/api-fahrplan
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Transport for Grenoble, France
- **Description**: Grenoble public transport
- **Documentation**: https://www.mobilites-m.fr/pages/opendata/OpenDataApi.html
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: No

### Transport for Hessen, Germany
- **Description**: RMV API (Public Transport in Hessen)
- **Documentation**: https://opendata.rmv.de/site/start.html
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Honolulu, US
- **Description**: Honolulu Transportation Information
- **Documentation**: http://hea.thebus.org/api_info.asp
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Transport for Lisbon, Portugal
- **Description**: Data about buses routes, parking and traffic
- **Documentation**: https://emel.city-platform.com/opendata/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for London, England
- **Description**: TfL API
- **Documentation**: https://api.tfl.gov.uk
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Los Angeles, US
- **Description**: Data about positions of Metro vehicles in real time and travel their routes
- **Documentation**: https://developer.metro.net/api/
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Manchester, England
- **Description**: TfGM transport network data
- **Documentation**: https://developer.tfgm.com/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Transport for Norway
- **Description**: Transport APIs and dataset for Norway
- **Documentation**: https://developer.entur.org/
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Ottawa, Canada
- **Description**: OC Transpo API
- **Documentation**: https://www.octranspo.com/en/plan-your-trip/travel-tools/developers
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Paris, France
- **Description**: RATP Open Data API
- **Documentation**: http://data.ratp.fr/api/v1/console/datasets/1.0/search/
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Transport for Philadelphia, US
- **Description**: SEPTA APIs
- **Documentation**: http://www3.septa.org/hackathon/
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Transport for Sao Paulo, Brazil
- **Description**: SPTrans
- **Documentation**: http://www.sptrans.com.br/desenvolvedores/api-do-olho-vivo-guia-de-referencia/documentacao-api/
- **Category**: Transportation
- **Auth Type**: OAuth2
- **HTTPS**: No
- **CORS**: Unknown

### Transport for Spain
- **Description**: Public trains of Spain
- **Documentation**: https://data.renfe.com/api/1/util/snippet/api_info.html?resource_id=a2368cff-1562-4dde-8466-9635ea3a572a
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Sweden
- **Description**: Public Transport consumer
- **Documentation**: https://www.trafiklab.se/api
- **Category**: Transportation
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Switzerland
- **Description**: Official Swiss Public Transport Open Data
- **Documentation**: https://opentransportdata.swiss/en/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Switzerland
- **Description**: Swiss public transport API
- **Documentation**: https://transport.opendata.ch/
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for The Netherlands
- **Description**: NS, only trains
- **Documentation**: http://www.ns.nl/reisinformatie/ns-api
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Transport for The Netherlands
- **Description**: OVAPI, country-wide public transport
- **Documentation**: https://github.com/skywave/KV78Turbo-OVAPI/wiki
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Toronto, Canada
- **Description**: TTC
- **Documentation**: https://myttc.ca/developers
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for UK
- **Description**: Transport API and dataset for UK
- **Documentation**: https://developer.transportapi.com
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for United States
- **Description**: NextBus API
- **Documentation**: https://retro.umoiq.com/xmlFeedDocs/NextBusXMLFeed.pdf
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Transport for Vancouver, Canada
- **Description**: TransLink
- **Documentation**: https://developer.translink.ca/
- **Category**: Transportation
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Transport for Washington, US
- **Description**: Washington Metro transport API
- **Documentation**: https://developer.wmata.com/
- **Category**: Transportation
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### transport.rest
- **Description**: Community maintained, developer-friendly public transport API
- **Documentation**: https://transport.rest
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Tripadvisor
- **Description**: Rating content for a hotel, restaurant, attraction or destination
- **Documentation**: https://developer-tripadvisor.com/home/
- **Category**: Transportation
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Uber
- **Description**: Uber ride requests and price estimation
- **Documentation**: https://developer.uber.com/products
- **Category**: Transportation
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

### Velib metropolis, Paris, France
- **Description**: Velib Open Data API
- **Documentation**: https://www.velib-metropole.fr/donnees-open-data-gbfs-du-service-velib-metropole
- **Category**: Transportation
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

---

## URL Shorteners

### 1pt
- **Description**: A simple URL shortener
- **Documentation**: https://github.com/1pt-co/api/blob/main/README.md
- **Category**: URL Shorteners
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Bitly
- **Description**: URL shortener and link management
- **Documentation**: http://dev.bitly.com/get_started.html
- **Category**: URL Shorteners
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### CleanURI
- **Description**: URL shortener service
- **Documentation**: https://cleanuri.com/docs
- **Category**: URL Shorteners
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### ClickMeter
- **Description**: Monitor, compare and optimize your marketing links
- **Documentation**: https://support.clickmeter.com/hc/en-us/categories/201474986
- **Category**: URL Shorteners
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Clico
- **Description**: URL shortener service
- **Documentation**: https://cli.com/swagger-ui/index.html?configUrl=/v3/api-docs/swagger-config
- **Category**: URL Shorteners
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Cutt.ly
- **Description**: URL shortener service
- **Documentation**: https://cutt.ly/api-documentation/cuttly-links-api
- **Category**: URL Shorteners
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Drivet URL Shortener
- **Description**: Shorten a long URL easily and fast
- **Documentation**: https://wiki.drivet.xyz/en/url-shortener/add-links
- **Category**: URL Shorteners
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Free Url Shortener
- **Description**: Free URL Shortener offers a powerful API to interact with other sites
- **Documentation**: https://ulvis.net/developer.html
- **Category**: URL Shorteners
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Git.io
- **Description**: Git.io URL shortener
- **Documentation**: https://github.blog/2011-11-10-git-io-github-url-shortener/
- **Category**: URL Shorteners
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### GoTiny
- **Description**: A lightweight URL shortener, focused on ease-of-use for the developer and end-user
- **Documentation**: https://github.com/robvanbakel/gotiny-api
- **Category**: URL Shorteners
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Kutt
- **Description**: Free Modern URL Shortener
- **Documentation**: https://docs.kutt.it/
- **Category**: URL Shorteners
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Mgnet.me
- **Description**: Torrent URL shorten API
- **Documentation**: http://mgnet.me/api.html
- **Category**: URL Shorteners
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### owo
- **Description**: A simple link obfuscator/shortener
- **Documentation**: https://owo.vc/api
- **Category**: URL Shorteners
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Rebrandly
- **Description**: Custom URL shortener for sharing branded links
- **Documentation**: https://developers.rebrandly.com/v1/docs
- **Category**: URL Shorteners
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Short Link
- **Description**: Short URLs support so many domains
- **Documentation**: https://github.com/FayasNoushad/Short-Link-API
- **Category**: URL Shorteners
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Shrtcode
- **Description**: URl Shortener with multiple Domains
- **Documentation**: https://shrtco.de/docs
- **Category**: URL Shorteners
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Shrtlnk
- **Description**: Simple and efficient short link creation
- **Documentation**: https://shrtlnk.dev/developer
- **Category**: URL Shorteners
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### TinyURL
- **Description**: Shorten long URLs
- **Documentation**: https://tinyurl.com/app/dev
- **Category**: URL Shorteners
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### UrlBae
- **Description**: Simple and efficient short link creation
- **Documentation**: https://urlbae.com/developers
- **Category**: URL Shorteners
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

---

## Vehicle

### Brazilian Vehicles and Prices
- **Description**: Vehicles information from Fundação Instituto de Pesquisas Econômicas - Fipe
- **Documentation**: https://deividfortuna.github.io/fipe/
- **Category**: Vehicle
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Helipaddy sites
- **Description**: Helicopter and passenger drone landing site directory, Helipaddy data and much more
- **Documentation**: https://helipaddy.com/api/
- **Category**: Vehicle
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Kelley Blue Book
- **Description**: Vehicle info, pricing, configuration, plus much more
- **Documentation**: http://developer.kbb.com/#!/data/1-Default
- **Category**: Vehicle
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Mercedes-Benz
- **Description**: Telematics data, remotely access vehicle functions, car configurator, locate service dealers
- **Documentation**: https://developer.mercedes-benz.com/apis
- **Category**: Vehicle
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### NHTSA
- **Description**: NHTSA Product Information Catalog and Vehicle Listing
- **Documentation**: https://vpic.nhtsa.dot.gov/api/
- **Category**: Vehicle
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Smartcar
- **Description**: Lock and unlock vehicles and get data like odometer reading and location. Works on most new cars
- **Documentation**: https://smartcar.com/docs/
- **Category**: Vehicle
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Yes

---

## Video

### An API of Ice And Fire
- **Description**: Game Of Thrones API
- **Documentation**: https://anapioficeandfire.com/
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Bob's Burgers
- **Description**: Bob's Burgers API
- **Documentation**: https://bobs-burgers-api-ui.herokuapp.com
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Breaking Bad
- **Description**: Breaking Bad API
- **Documentation**: https://breakingbadapi.com/documentation
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Breaking Bad Quotes
- **Description**: Some Breaking Bad quotes
- **Documentation**: https://github.com/shevabam/breaking-bad-quotes
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Catalogopolis
- **Description**: Doctor Who API
- **Documentation**: https://api.catalogopolis.xyz/docs/
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Catch The Show
- **Description**: REST API for next-episode.net
- **Documentation**: https://catchtheshow.herokuapp.com/api/documentation
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Czech Television
- **Description**: TV programme of Czech TV
- **Documentation**: http://www.ceskatelevize.cz/xml/tv-program/
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Dailymotion
- **Description**: Dailymotion Developer API
- **Documentation**: https://developer.dailymotion.com/
- **Category**: Video
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Dune
- **Description**: A simple API which provides you with book, character, movie and quotes JSON data
- **Documentation**: https://github.com/ywalia01/dune-api
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Final Space
- **Description**: Final Space API
- **Documentation**: https://finalspaceapi.com/docs/
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Game of Thrones Quotes
- **Description**: Some Game of Thrones quotes
- **Documentation**: https://gameofthronesquotes.xyz/
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Harry Potter Charactes
- **Description**: Harry Potter Characters Data with with imagery
- **Documentation**: https://hp-api.herokuapp.com/
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### IMDb-API
- **Description**: API for receiving movie, serial and cast information
- **Documentation**: https://imdb-api.com/
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### IMDbOT
- **Description**: Unofficial IMDb Movie / Series Information
- **Documentation**: https://github.com/SpEcHiDe/IMDbOT
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### JSON2Video
- **Description**: Create and edit videos programmatically: watermarks,resizing,slideshows,voice-over,text animations
- **Documentation**: https://json2video.com
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

### Lucifer Quotes
- **Description**: Returns Lucifer quotes
- **Documentation**: https://github.com/shadowoff09/lucifer-quotes
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### MCU Countdown
- **Description**: A Countdown to the next MCU Film
- **Documentation**: https://github.com/DiljotSG/MCU-Countdown
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Motivational Quotes
- **Description**: Random Motivational Quotes
- **Documentation**: https://nodejs-quoteapp.herokuapp.com/
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Movie Quote
- **Description**: Random Movie and Series Quotes
- **Documentation**: https://github.com/F4R4N/movie-quote/
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Open Movie Database
- **Description**: Movie information
- **Documentation**: http://www.omdbapi.com/
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Owen Wilson Wow
- **Description**: API for actor Owen Wilson's "wow" exclamations in movies
- **Documentation**: https://owen-wilson-wow-api.herokuapp.com
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Ron Swanson Quotes
- **Description**: Television
- **Documentation**: https://github.com/jamesseanwright/ron-swanson-quotes#ron-swanson-quotes-api
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Simkl
- **Description**: Movie, TV and Anime data
- **Documentation**: https://simkl.docs.apiary.io
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### STAPI
- **Description**: Information on all things Star Trek
- **Documentation**: http://stapi.co
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: No

### Stranger Things Quotes
- **Description**: Returns Stranger Things quotes
- **Documentation**: https://github.com/shadowoff09/strangerthings-quotes
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Stream
- **Description**: Czech internet television, films, series and online videos for free
- **Documentation**: https://api.stream.cz/graphiql
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Stromberg Quotes
- **Description**: Returns Stromberg quotes and more
- **Documentation**: https://www.stromberg-api.de/
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### SWAPI
- **Description**: All the Star Wars data you've ever wanted
- **Documentation**: https://swapi.dev/
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### SWAPI
- **Description**: All things Star Wars
- **Documentation**: https://www.swapi.tech
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### SWAPI GraphQL
- **Description**: Star Wars GraphQL API
- **Documentation**: https://graphql.org/swapi-graphql
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### The Lord of the Rings
- **Description**: The Lord of the Rings API
- **Documentation**: https://the-one-api.dev/
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### The Vampire Diaries
- **Description**: TV Show Data
- **Documentation**: https://vampire-diaries-api.netlify.app/
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### ThronesApi
- **Description**: Game Of Thrones Characters Data with imagery
- **Documentation**: https://thronesapi.com/
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### TMDb
- **Description**: Community-based movie data
- **Documentation**: https://www.themoviedb.org/documentation/api
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### TrailerAddict
- **Description**: Easily embed trailers from TrailerAddict
- **Documentation**: https://www.traileraddict.com/trailerapi
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Trakt
- **Description**: Movie and TV Data
- **Documentation**: https://trakt.docs.apiary.io/
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### TVDB
- **Description**: Television data
- **Documentation**: https://thetvdb.com/api-information
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### TVMaze
- **Description**: TV Show Data
- **Documentation**: http://www.tvmaze.com/api
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### uNoGS
- **Description**: Unofficial Netflix Online Global Search, Search all netflix regions in one place
- **Documentation**: https://rapidapi.com/unogs/api/unogsng
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Vimeo
- **Description**: Vimeo Developer API
- **Documentation**: https://developer.vimeo.com/
- **Category**: Video
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### Watchmode
- **Description**: API for finding out the streaming availability of movies & shows
- **Documentation**: https://api.watchmode.com/
- **Category**: Video
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Web Series Quotes Generator
- **Description**: API generates various Web Series Quote Images
- **Documentation**: https://github.com/yogeshwaran01/web-series-quotes
- **Category**: Video
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### YouTube
- **Description**: Add YouTube functionality to your sites and apps
- **Documentation**: https://developers.google.com/youtube/
- **Category**: Video
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

---

## Weather

### 7Timer!
- **Description**: Weather, especially for Astroweather
- **Documentation**: http://www.7timer.info/doc.php?lang=en
- **Category**: Weather
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### AccuWeather
- **Description**: Weather and forecast data
- **Documentation**: https://developer.accuweather.com/apis
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: No
- **CORS**: Unknown

### Aemet
- **Description**: Weather and forecast data from Spain
- **Documentation**: https://opendata.aemet.es/centrodedescargas/inicio
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### apilayer weatherstack
- **Description**: Real-Time & Historical World Weather Data API
- **Documentation**: https://weatherstack.com/
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### APIXU
- **Description**: Weather
- **Documentation**: https://www.apixu.com/doc/request.aspx
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### AQICN
- **Description**: Air Quality Index Data for over 1000 cities
- **Documentation**: https://aqicn.org/api/
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### AviationWeather
- **Description**: NOAA aviation weather forecasts and observations
- **Documentation**: https://www.aviationweather.gov/dataserver
- **Category**: Weather
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### ColorfulClouds
- **Description**: Weather
- **Documentation**: https://open.caiyunapp.com/ColorfulClouds_Weather_API
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Euskalmet
- **Description**: Meteorological data of the Basque Country
- **Documentation**: https://opendata.euskadi.eus/api-euskalmet/-/api-de-euskalmet/
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Foreca
- **Description**: Weather
- **Documentation**: https://developer.foreca.com
- **Category**: Weather
- **Auth Type**: OAuth2
- **HTTPS**: Yes
- **CORS**: Unknown

### HG Weather
- **Description**: Provides weather forecast data for cities in Brazil
- **Documentation**: https://hgbrasil.com/status/weather
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Hong Kong Obervatory
- **Description**: Provide weather information, earthquake information, and climate data
- **Documentation**: https://www.hko.gov.hk/en/abouthko/opendata_intro.htm
- **Category**: Weather
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### MetaWeather
- **Description**: Weather
- **Documentation**: https://www.metaweather.com/api/
- **Category**: Weather
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### Meteorologisk Institutt
- **Description**: Weather and climate data
- **Documentation**: https://api.met.no/weatherapi/documentation
- **Category**: Weather
- **Auth Type**: User-Agent
- **HTTPS**: Yes
- **CORS**: Unknown

### Micro Weather
- **Description**: Real time weather forecasts and historic data
- **Documentation**: https://m3o.com/weather/api
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### ODWeather
- **Description**: Weather and weather webcams
- **Documentation**: http://api.oceandrivers.com/static/docs.html
- **Category**: Weather
- **Auth Type**: None
- **HTTPS**: No
- **CORS**: Unknown

### Oikolab
- **Description**: 70+ years of global, hourly historical and forecast weather data from NOAA and ECMWF
- **Documentation**: https://docs.oikolab.com
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Open-Meteo
- **Description**: Global weather forecast API for non-commercial use
- **Documentation**: https://open-meteo.com/
- **Category**: Weather
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### openSenseMap
- **Description**: Data from Personal Weather Stations called senseBoxes
- **Documentation**: https://api.opensensemap.org/
- **Category**: Weather
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### OpenUV
- **Description**: Real-time UV Index Forecast
- **Documentation**: https://www.openuv.io
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### OpenWeatherMap
- **Description**: Weather
- **Documentation**: https://openweathermap.org/api
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### QWeather
- **Description**: Location-based weather data
- **Documentation**: https://dev.qweather.com/en/
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### RainViewer
- **Description**: Radar data collected from different websites across the Internet
- **Documentation**: https://www.rainviewer.com/api.html
- **Category**: Weather
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Unknown

### Storm Glass
- **Description**: Global marine weather from multiple sources
- **Documentation**: https://stormglass.io/
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Tomorrow
- **Description**: Weather API Powered by Proprietary Technology
- **Documentation**: https://docs.tomorrow.io
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### US Weather
- **Description**: US National Weather Service
- **Documentation**: https://www.weather.gov/documentation/services-web-api
- **Category**: Weather
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: Yes

### Visual Crossing
- **Description**: Global historical and weather forecast data
- **Documentation**: https://www.visualcrossing.com/weather-api
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### weather-api
- **Description**: A RESTful free API to check the weather
- **Documentation**: https://github.com/robertoduessmann/weather-api
- **Category**: Weather
- **Auth Type**: None
- **HTTPS**: Yes
- **CORS**: No

### WeatherAPI
- **Description**: Weather API with other stuff like Astronomy and Geolocation API
- **Documentation**: https://www.weatherapi.com/
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Yes

### Weatherbit
- **Description**: Weather
- **Documentation**: https://www.weatherbit.io/api
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: Unknown

### Yandex.Weather
- **Description**: Assesses weather condition in specific locations
- **Documentation**: https://yandex.com/dev/weather/
- **Category**: Weather
- **Auth Type**: API Key
- **HTTPS**: Yes
- **CORS**: No

---
